/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.WarpDist;
import io.warp10.crypto.SipHashInline;
import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.functions.INCLUDE;
import io.warp10.script.functions.MSGFAIL;
import io.warp10.sensision.Sensision;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

public class WarpScriptMacroRepository
extends Thread {
    private static final MSGFAIL MSGFAIL_FUNC = new MSGFAIL("MSGFAIL");
    private static final long DEFAULT_DELAY = 3600000L;
    private static final long DEFAULT_MACRO_TTL = 600000L;
    private static final long DEFAULT_FAILED_MACRO_TTL = 10000L;
    private static long[] SIP_KEYS = new long[]{31232312312312L, 543534535435L};
    public static final String WARPSCRIPT_FILE_EXTENSION = ".mc2";
    private static String directory;
    private static long delay;
    private static long ttl;
    private static long failedTtl;
    private static ThreadLocal<List<String>> loading;
    private static boolean ondemand;
    private static final Map<String, WarpScriptStack.Macro> macros;

    private WarpScriptMacroRepository() {
        this.setName("[Warp Macro Repository (" + directory + ")");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!WarpDist.isInitialized()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!WarpDist.isEgress()) {
            return;
        }
        while (true) {
            String rootdir = new File(directory).getAbsolutePath();
            List<File> files = this.getWarpScriptFiles(directory);
            HashMap<String, WarpScriptStack.Macro> newmacros = new HashMap<String, WarpScriptStack.Macro>();
            boolean hasNew = false;
            for (File file : files) {
                WarpScriptStack.Macro macro;
                String name = file.getAbsolutePath().substring(rootdir.length() + 1).replaceAll("\\.mc2$", "");
                if (!name.contains(File.separator) || null == (macro = WarpScriptMacroRepository.loadMacro(name = name.replaceAll(Pattern.quote(File.separator), "/"), file))) continue;
                newmacros.put(name, macro);
                if (macro.equals(macros.get(name))) continue;
                hasNew = true;
            }
            if (hasNew) {
                Map<String, WarpScriptStack.Macro> map = macros;
                synchronized (map) {
                    macros.clear();
                    macros.putAll(newmacros);
                }
            }
            Sensision.set((String)"warp.script.repository.macros", (Map)Sensision.EMPTY_LABELS, (Object)newmacros.size());
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WarpScriptStack.Macro find(String name) throws WarpScriptException {
        WarpScriptStack.Macro macro = null;
        Map<String, WarpScriptStack.Macro> map = macros;
        synchronized (map) {
            macro = macros.get(name);
        }
        if (ondemand && null != macro && macro.isExpired()) {
            macro = null;
        }
        if (null == macro && ondemand && null != (macro = WarpScriptMacroRepository.loadMacro(name, null))) {
            map = macros;
            synchronized (map) {
                macros.put(name, macro);
            }
        }
        return macro;
    }

    public List<File> getWarpScriptFiles(String rootdir) {
        File root = new File(rootdir);
        final ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> allfiles = new ArrayList<File>();
        if (!root.exists()) {
            return allfiles;
        }
        dirs.add(root);
        int idx = 0;
        while (idx < dirs.size()) {
            File dir;
            File[] files;
            if (null == (files = (dir = (File)dirs.get(idx++)).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (".".equals(name) || "..".equals(name)) {
                        return false;
                    }
                    File f = new File(dir, name);
                    if (f.isDirectory()) {
                        dirs.add(f);
                        return false;
                    }
                    return name.endsWith(WarpScriptMacroRepository.WARPSCRIPT_FILE_EXTENSION) || new File(dir, name).isDirectory();
                }
            }))) continue;
            for (File file : files) {
                allfiles.add(file);
            }
        }
        return allfiles;
    }

    public static void init(Properties properties) {
        String dir = properties.getProperty("warpscript.repository.directory");
        if (null == dir) {
            return;
        }
        long refreshDelay = 3600000L;
        String refresh = properties.getProperty("warpscript.repository.refresh");
        if (null != refresh) {
            try {
                refreshDelay = Long.parseLong(refresh.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        directory = dir;
        delay = refreshDelay;
        ttl = Long.parseLong(properties.getProperty("warpscript.repository.ttl", Long.toString(600000L)));
        failedTtl = Long.parseLong(properties.getProperty("warpscript.repository.ttl.failed", Long.toString(10000L)));
        ondemand = !"false".equals(properties.getProperty("warpscript.repository.ondemand"));
        new WarpScriptMacroRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WarpScriptStack.Macro loadMacro(String name, File file) {
        if (null == name && null == file) {
            return null;
        }
        if (name.contains("/../") || name.contains("/./") || name.startsWith("../") || name.startsWith("./") || name.startsWith("/")) {
            return null;
        }
        if (!name.contains("/")) {
            return null;
        }
        String rootdir = new File(directory).getAbsolutePath();
        if (null == file && !(file = !"/".equals(File.separator) ? new File(rootdir, name.replaceAll("/", File.separator) + WARPSCRIPT_FILE_EXTENSION) : new File(rootdir, name + WARPSCRIPT_FILE_EXTENSION)).getAbsolutePath().startsWith(rootdir)) {
            return null;
        }
        if (null == name) {
            name = file.getAbsolutePath().substring(rootdir.length() + 1).replaceAll("\\.mc2$", "");
            name = name.replaceAll(Pattern.quote(File.separator), "/");
        }
        byte[] buf = new byte[8192];
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        try {
            int len;
            if (loading.get().contains(name)) {
                StringBuilder seq = new StringBuilder();
                for (String macname : loading.get()) {
                    if (seq.length() > 0) {
                        seq.append(" >>> ");
                    }
                    seq.append("@");
                    seq.append(macname);
                }
                throw new WarpScriptException("Invalid recursive macro loading (" + seq.toString() + ")");
            }
            loading.get().add(name);
            if (!file.exists()) {
                WarpScriptStack.Macro seq = null;
                return seq;
            }
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            in.close();
            byte[] data = out.toByteArray();
            long hash = SipHashInline.hash24_palindromic(SIP_KEYS[0], SIP_KEYS[1], data);
            WarpScriptStack.Macro old = macros.get(name);
            if (null != old && hash == old.getFingerprint() && ondemand && !old.isExpired()) {
                WarpScriptStack.Macro macro = old;
                return macro;
            }
            sb.append(new String(data, StandardCharsets.UTF_8));
            sb.append("\n");
            MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null);
            stack.maxLimits();
            stack.setAttribute("macro.name", name);
            AtomicBoolean enabled = new AtomicBoolean(true);
            final INCLUDE include = new INCLUDE("INCLUDE", new File(rootdir, name.replaceAll("/.*", "")), enabled);
            stack.define("INCLUDE", new WarpScriptStack.Macro(){

                @Override
                public boolean isSecure() {
                    return true;
                }

                @Override
                public List<Object> statements() {
                    return new ArrayList<Object>(){
                        {
                            this.add(include);
                        }
                    };
                }
            });
            stack.execMulti(sb.toString());
            enabled.set(false);
            if (1 != stack.depth()) {
                throw new WarpScriptException("Stack depth was not 1 after the code execution.");
            }
            if (!(stack.peek() instanceof WarpScriptStack.Macro)) {
                throw new WarpScriptException("No macro was found on top of the stack.");
            }
            WarpScriptStack.Macro macro = (WarpScriptStack.Macro)stack.pop();
            if (ondemand && null != stack.getAttribute("macro.ttl")) {
                macro.setExpiry(System.currentTimeMillis() + (Long)stack.getAttribute("macro.ttl"));
            } else if (ondemand) {
                macro.setExpiry(System.currentTimeMillis() + ttl);
            }
            macro.setFingerprint(hash);
            macro.setSecure(true);
            macro.setNameRecursive(name);
            WarpScriptStack.Macro macro2 = macro;
            return macro2;
        }
        catch (Exception e) {
            WarpScriptStack.Macro macro = new WarpScriptStack.Macro();
            macro.add("[" + System.currentTimeMillis() + "] Error while loading macro '" + name + "': " + e.getMessage());
            macro.add(MSGFAIL_FUNC);
            if (ondemand) {
                macro.setExpiry(System.currentTimeMillis() + Math.max(delay / 2L, failedTtl));
            }
            macro.setFingerprint(0L);
            WarpScriptStack.Macro macro3 = macro;
            return macro3;
        }
        finally {
            loading.get().remove(loading.get().size() - 1);
        }
    }

    static {
        delay = 3600000L;
        ttl = 600000L;
        failedTtl = 10000L;
        loading = new ThreadLocal<List<String>>(){

            @Override
            protected List<String> initialValue() {
                return new ArrayList<String>();
            }
        };
        ondemand = false;
        macros = new HashMap<String, WarpScriptStack.Macro>();
    }
}

