/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import io.warp10.WarpURLEncoder;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class Join
extends NamedWarpScriptFunction
implements WarpScriptAggregatorFunction,
WarpScriptMapperFunction,
WarpScriptBucketizerFunction,
WarpScriptReducerFunction {
    private final boolean ignoreNulls;
    private final boolean urlencode;
    private final String separator;
    private final String nullString;

    public Join(String name, String separator, boolean ignoreNulls, boolean urlencode, String nullString) {
        super(name);
        this.separator = separator;
        this.ignoreNulls = ignoreNulls;
        this.urlencode = urlencode;
        this.nullString = nullString;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == ticks.length) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        StringBuilder sb = new StringBuilder();
        long location = 91480763316633925L;
        long elevation = Long.MIN_VALUE;
        long timestamp = Long.MIN_VALUE;
        boolean hasNulls = false;
        boolean first = true;
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (ticks[i] > timestamp) {
                location = locations[i];
                elevation = elevations[i];
                timestamp = ticks[i];
            }
            if (null == value) {
                hasNulls = true;
                if (null != this.nullString) {
                    if (!first) {
                        sb.append(this.separator);
                    }
                    sb.append(this.nullString);
                }
                first = false;
                continue;
            }
            if (!first) {
                sb.append(this.separator);
            }
            first = false;
            if (this.urlencode) {
                try {
                    sb.append(WarpURLEncoder.encode(value.toString(), StandardCharsets.UTF_8));
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    throw new WarpScriptException(uee);
                }
            }
            sb.append(value.toString());
        }
        String result = null;
        result = hasNulls && !this.ignoreNulls ? null : sb.toString();
        return new Object[]{0L, location, elevation, result};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.separator));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        private final boolean ignoreNulls;
        private final boolean urlencode;
        private final String nulLString;

        public Builder(String name, boolean ignoreNulls, boolean urlencode, String nullString) {
            super(name);
            this.ignoreNulls = ignoreNulls;
            this.urlencode = urlencode;
            this.nulLString = nullString;
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object sep = stack.pop();
            stack.push(new Join(this.getName(), sep.toString(), this.ignoreNulls, this.urlencode, this.nulLString));
            return stack;
        }
    }
}

