/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import com.geoxp.GeoXPLib;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Arrays;
import java.util.Comparator;

public class Percentile
extends NamedWarpScriptFunction
implements WarpScriptAggregatorFunction,
WarpScriptMapperFunction,
WarpScriptBucketizerFunction,
WarpScriptReducerFunction {
    final boolean interpolate;
    final double percentile;

    public Percentile(String name, double percentile, boolean interpolate) {
        super(name);
        this.percentile = percentile < 0.0 ? 0.0 : (percentile > 100.0 ? 100.0 : percentile);
        this.interpolate = interpolate;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        final Object[] values = (Object[])args[6];
        if (0 == ticks.length) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        Integer[] indices = new Integer[values.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        try {
            Arrays.sort(indices, new Comparator<Integer>(){

                @Override
                public int compare(Integer idx1, Integer idx2) {
                    if (values[idx1] instanceof Double) {
                        return Double.compare(((Number)values[idx1]).doubleValue(), ((Number)values[idx2]).doubleValue());
                    }
                    if (values[idx1] instanceof Long) {
                        return Long.compare(((Number)values[idx1]).longValue(), ((Number)values[idx2]).longValue());
                    }
                    throw new RuntimeException("PERCENTILE can only operate on numeric Geo Time Series.");
                }
            });
        }
        catch (RuntimeException re) {
            throw new WarpScriptException(re);
        }
        int n = (int)Math.round(0.5 + this.percentile * (double)indices.length / 100.0) - 1;
        if (!this.interpolate) {
            if (n >= indices.length) {
                --n;
            }
            return new Object[]{ticks[indices[n]], locations[indices[n]], elevations[indices[n]], values[indices[n]]};
        }
        int m = (int)Math.floor(0.5 + this.percentile * (double)indices.length / 100.0) - 1;
        double pn = 100.0 / (double)indices.length * ((double)(n + 1) - 0.5);
        double pm = 100.0 / (double)indices.length * ((double)(m + 1) - 0.5);
        if (0 == n && this.percentile < pn) {
            return new Object[]{ticks[indices[0]], locations[indices[0]], elevations[indices[0]], values[indices[0]]};
        }
        if (m == indices.length - 1 && this.percentile > pm) {
            return new Object[]{ticks[indices[m]], locations[indices[m]], elevations[indices[m]], values[indices[m]]};
        }
        if (pn == this.percentile) {
            return new Object[]{ticks[indices[n]], locations[indices[n]], elevations[indices[n]], values[indices[n]]};
        }
        if (pm == this.percentile) {
            return new Object[]{ticks[indices[m]], locations[indices[m]], elevations[indices[m]], values[indices[m]]};
        }
        if (pm < this.percentile && this.percentile < pn) {
            double factor = (double)indices.length * (this.percentile - pm) / 100.0;
            long tick = (long)((double)ticks[indices[m]] + factor * (double)(ticks[indices[n]] - ticks[indices[m]]));
            double v = values[indices[m]] instanceof Long ? (double)((Number)values[indices[m]]).longValue() + factor * (double)(((Number)values[indices[n]]).longValue() - ((Number)values[indices[m]]).longValue()) : ((Number)values[indices[m]]).doubleValue() + factor * (((Number)values[indices[n]]).doubleValue() - ((Number)values[indices[m]]).doubleValue());
            long location = 91480763316633925L;
            if (91480763316633925L != locations[indices[m]] && 91480763316633925L != locations[indices[n]]) {
                double[] latlonm = GeoXPLib.fromGeoXPPoint((long)locations[indices[m]]);
                double[] latlonn = GeoXPLib.fromGeoXPPoint((long)locations[indices[n]]);
                double lat = latlonm[0] + factor * (latlonn[0] - latlonm[0]);
                double lon = latlonm[1] + factor * (latlonn[1] - latlonm[1]);
                location = GeoXPLib.toGeoXPPoint((double)lat, (double)lon);
            }
            long elevation = Long.MIN_VALUE;
            if (91480763316633925L != elevations[indices[m]] && Long.MIN_VALUE != elevations[indices[n]]) {
                elevation = (long)((double)elevations[indices[m]] + factor * (double)(elevations[indices[n]] - elevations[indices[m]]));
            }
            return new Object[]{tick, location, elevation, v};
        }
        throw new WarpScriptException("Twilight zone!");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.percentile));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object value = stack.pop();
            if (!(value instanceof Number)) {
                throw new WarpScriptException("Invalid parameter for " + this.getName());
            }
            double percentile = ((Number)value).doubleValue();
            if (percentile < 0.0 || percentile > 100.0) {
                throw new WarpScriptException("Invalid percentile, MUST be between 0 and 100.");
            }
            stack.push(new Percentile(this.getName(), percentile, false));
            return stack;
        }
    }
}

