/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;

public class RMS
extends NamedWarpScriptFunction
implements WarpScriptAggregatorFunction,
WarpScriptMapperFunction,
WarpScriptBucketizerFunction,
WarpScriptReducerFunction {
    private final boolean ignoreNulls;

    public RMS(String name, boolean ignoreNulls) {
        super(name);
        this.ignoreNulls = ignoreNulls;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == ticks.length) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        GeoTimeSerie.TYPE sumType = GeoTimeSerie.TYPE.UNDEFINED;
        double sqsumd = 0.0;
        double rms = 0.0;
        long location = 91480763316633925L;
        long elevation = Long.MIN_VALUE;
        long timestamp = Long.MIN_VALUE;
        int nulls = 0;
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (ticks[i] > timestamp) {
                location = locations[i];
                elevation = elevations[i];
                timestamp = ticks[i];
            }
            if (null == value) {
                ++nulls;
                continue;
            }
            if (GeoTimeSerie.TYPE.UNDEFINED == sumType) {
                if (value instanceof Long) {
                    sumType = GeoTimeSerie.TYPE.LONG;
                } else if (value instanceof Double) {
                    sumType = GeoTimeSerie.TYPE.DOUBLE;
                } else {
                    return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
                }
            }
            sqsumd += Math.pow(((Number)value).doubleValue(), 2.0);
        }
        Number meanvalue = null;
        if (!this.ignoreNulls && nulls > 0) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        if (values.length == nulls) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        rms = Math.sqrt(sqsumd / (double)(values.length - nulls));
        if (GeoTimeSerie.TYPE.LONG == sumType) {
            meanvalue = (long)rms;
        } else if (GeoTimeSerie.TYPE.DOUBLE == sumType) {
            meanvalue = rms;
        }
        return new Object[]{tick, location, elevation, meanvalue};
    }
}

