/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.binary;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSOpsHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.List;

public abstract class CondShortCircuit
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    protected final boolean triggerValue;
    private final GTSOpsHelper.GTSBinaryOp op = new GTSOpsHelper.GTSBinaryOp(){

        @Override
        public Object op(GeoTimeSerie gtsa, GeoTimeSerie gtsb, int idxa, int idxb) {
            return CondShortCircuit.this.operator((Boolean)GTSHelper.valueAtIndex(gtsa, idxa), (Boolean)GTSHelper.valueAtIndex(gtsb, idxb));
        }
    };

    public abstract boolean operator(boolean var1, boolean var2);

    public CondShortCircuit(String name, boolean triggerValue) {
        super(name);
        this.triggerValue = triggerValue;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        String exceptionMessage = this.getName() + " can only operate on two boolean values, or two boolean GTS, or a list of booleans or macros, each macro putting a single boolean on top of the stack.";
        Object top = stack.pop();
        if (top instanceof List) {
            for (Object operand : (List)top) {
                if (operand instanceof WarpScriptStack.Macro) {
                    stack.exec((WarpScriptStack.Macro)operand);
                    operand = stack.pop();
                }
                if (operand instanceof Boolean) {
                    if (this.triggerValue != (Boolean)operand) continue;
                    stack.push(this.triggerValue);
                    return stack;
                }
                throw new WarpScriptException(exceptionMessage);
            }
            stack.push(!this.triggerValue);
            return stack;
        }
        Object op2 = top;
        Object op1 = stack.pop();
        if (op2 instanceof Boolean && op1 instanceof Boolean) {
            stack.push(this.operator((Boolean)op1, (Boolean)op2));
            return stack;
        }
        if (op1 instanceof GeoTimeSerie && op2 instanceof GeoTimeSerie) {
            GeoTimeSerie gts1 = (GeoTimeSerie)op1;
            GeoTimeSerie gts2 = (GeoTimeSerie)op2;
            if (GeoTimeSerie.TYPE.BOOLEAN == gts1.getType() && GeoTimeSerie.TYPE.BOOLEAN == gts2.getType()) {
                GeoTimeSerie result = new GeoTimeSerie(Math.max(GTSHelper.nvalues(gts1), GTSHelper.nvalues(gts2)));
                result.setType(GeoTimeSerie.TYPE.BOOLEAN);
                GTSOpsHelper.applyBinaryOp(result, gts1, gts2, this.op);
                stack.push(result);
                return stack;
            }
            if (GeoTimeSerie.TYPE.UNDEFINED == gts1.getType() && GeoTimeSerie.TYPE.BOOLEAN == gts2.getType() || GeoTimeSerie.TYPE.UNDEFINED == gts2.getType() && GeoTimeSerie.TYPE.BOOLEAN == gts1.getType()) {
                stack.push(new GeoTimeSerie());
                return stack;
            }
            throw new WarpScriptException(this.getName() + " can only operate on long values or long GTS.");
        }
        throw new WarpScriptException(exceptionMessage);
    }
}

