/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.binary;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class MUL
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final String typeCheckErrorMsg = this.getName() + " can only operate on numeric values, vectors, matrices and numeric Geo Time Series.";

    public MUL(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object op2 = stack.pop();
        Object op1 = stack.pop();
        if (op2 instanceof Number && op1 instanceof Number) {
            if (op1 instanceof Double || op2 instanceof Double) {
                stack.push(((Number)op1).doubleValue() * ((Number)op2).doubleValue());
            } else {
                stack.push(((Number)op1).longValue() * ((Number)op2).longValue());
            }
        } else if (op2 instanceof RealMatrix && op1 instanceof RealMatrix) {
            stack.push(((RealMatrix)op1).multiply((RealMatrix)op2));
        } else if (op1 instanceof RealMatrix && op2 instanceof Number) {
            stack.push(((RealMatrix)op1).scalarMultiply(((Number)op2).doubleValue()));
        } else if (op2 instanceof RealMatrix && op1 instanceof Number) {
            stack.push(((RealMatrix)op2).scalarMultiply(((Number)op1).doubleValue()));
        } else if (op2 instanceof RealMatrix && op1 instanceof RealVector) {
            stack.push(((RealMatrix)op2).preMultiply((RealVector)op1));
        } else if (op1 instanceof RealMatrix && op2 instanceof RealVector) {
            stack.push(((RealMatrix)op1).operate((RealVector)op2));
        } else if (op1 instanceof RealVector && op2 instanceof Number) {
            stack.push(((RealVector)op1).mapMultiply(((Number)op2).doubleValue()));
        } else if (op2 instanceof RealVector && op1 instanceof Number) {
            stack.push(((RealVector)op2).mapMultiply(((Number)op1).doubleValue()));
        } else if (op1 instanceof GeoTimeSerie && op2 instanceof GeoTimeSerie) {
            GeoTimeSerie gts1 = (GeoTimeSerie)op1;
            GeoTimeSerie gts2 = (GeoTimeSerie)op2;
            if (gts1.getType() != GeoTimeSerie.TYPE.DOUBLE && gts1.getType() != GeoTimeSerie.TYPE.LONG || gts2.getType() != GeoTimeSerie.TYPE.DOUBLE && gts2.getType() != GeoTimeSerie.TYPE.LONG) {
                throw new WarpScriptException(this.typeCheckErrorMsg);
            }
            GeoTimeSerie result = new GeoTimeSerie(Math.max(GTSHelper.nvalues(gts1), GTSHelper.nvalues(gts2)));
            if (GTSHelper.isBucketized(gts1) && GTSHelper.isBucketized(gts2) && GTSHelper.getBucketSpan(gts1) == GTSHelper.getBucketSpan(gts2)) {
                long bucketspan = GTSHelper.getBucketSpan(gts1);
                if (GTSHelper.getLastBucket(gts1) % bucketspan == GTSHelper.getLastBucket(gts2) % bucketspan) {
                    GTSHelper.setBucketSpan(result, bucketspan);
                    GTSHelper.setLastBucket(result, Math.max(GTSHelper.getLastBucket(gts1), GTSHelper.getLastBucket(gts2)));
                    long firstbucket = Math.min(GTSHelper.getLastBucket(gts1) - (long)(GTSHelper.getBucketCount(gts1) - 1) * bucketspan, GTSHelper.getLastBucket(gts2) - (long)(GTSHelper.getBucketCount(gts2) - 1) * bucketspan);
                    int bucketcount = (int)((GTSHelper.getLastBucket(result) - firstbucket) / bucketspan) + 1;
                    GTSHelper.setBucketCount(result, bucketcount);
                }
            }
            result.setType(GeoTimeSerie.TYPE.DOUBLE);
            GTSHelper.sort(gts1);
            GTSHelper.sort(gts2);
            int idxa = 0;
            int idxb = 0;
            int na = GTSHelper.nvalues(gts1);
            int nb = GTSHelper.nvalues(gts2);
            Long tsa = null;
            Long tsb = null;
            if (idxa < na) {
                tsa = GTSHelper.tickAtIndex(gts1, idxa);
            }
            if (idxb < na) {
                tsb = GTSHelper.tickAtIndex(gts2, idxb);
            }
            while (idxa < na || idxb < nb) {
                if (idxa >= na) {
                    tsa = null;
                }
                if (idxb >= nb) {
                    tsb = null;
                }
                if (null != tsa && null != tsb) {
                    if (0 == tsa.compareTo(tsb)) {
                        GTSHelper.setValue(result, tsa, ((Number)GTSHelper.valueAtIndex(gts1, idxa)).doubleValue() * ((Number)GTSHelper.valueAtIndex(gts2, idxb)).doubleValue());
                        ++idxa;
                        ++idxb;
                    } else if (tsa < tsb) {
                        ++idxa;
                    } else {
                        ++idxb;
                    }
                } else if (null == tsa && null != tsb) {
                    ++idxb;
                } else if (null == tsb && null != tsa) {
                    ++idxa;
                }
                if (idxa < na) {
                    tsa = GTSHelper.tickAtIndex(gts1, idxa);
                }
                if (idxb >= nb) continue;
                tsb = GTSHelper.tickAtIndex(gts2, idxb);
            }
            stack.push(result);
        } else if (op1 instanceof GeoTimeSerie && op2 instanceof Number || op1 instanceof Number && op2 instanceof GeoTimeSerie) {
            GeoTimeSerie gts;
            boolean op1gts = op1 instanceof GeoTimeSerie;
            int n = op1gts ? GTSHelper.nvalues((GeoTimeSerie)op1) : GTSHelper.nvalues((GeoTimeSerie)op2);
            GeoTimeSerie result = op1gts ? ((GeoTimeSerie)op1).cloneEmpty(n) : ((GeoTimeSerie)op2).cloneEmpty();
            GeoTimeSerie geoTimeSerie = gts = op1gts ? (GeoTimeSerie)op1 : (GeoTimeSerie)op2;
            if (gts.getType() != GeoTimeSerie.TYPE.LONG && gts.getType() != GeoTimeSerie.TYPE.DOUBLE) {
                throw new WarpScriptException(this.typeCheckErrorMsg);
            }
            double op = op1gts ? ((Number)op2).doubleValue() : ((Number)op1).doubleValue();
            for (int i = 0; i < n; ++i) {
                double value = ((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue() * op;
                GTSHelper.setValue(result, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), value, false);
            }
            stack.push(result);
        } else {
            throw new WarpScriptException(this.typeCheckErrorMsg);
        }
        return stack;
    }
}

