/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.hbase;

import io.warp10.continuum.MetadataUtils;
import io.warp10.continuum.egress.HBaseStoreClient;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.StoreClient;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.util.Bytes;

public class HLOCATE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public HLOCATE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of Geo Time Series on top of the stack.");
        }
        StoreClient sc = stack.getStoreClient();
        if (!(sc instanceof HBaseStoreClient)) {
            throw new WarpScriptException(this.getName() + " only works with an HBase storage backend.");
        }
        HBaseStoreClient hbsc = (HBaseStoreClient)sc;
        RegionLocator locator = null;
        List regions = null;
        try {
            locator = hbsc.getRegionLocator();
            regions = locator.getAllRegionLocations();
        }
        catch (IOException ioe) {
            throw new WarpScriptException(ioe);
        }
        regions.sort(new Comparator<HRegionLocation>(){

            @Override
            public int compare(HRegionLocation o1, HRegionLocation o2) {
                return Bytes.compareTo((byte[])o1.getRegionInfo().getStartKey(), (byte[])o2.getRegionInfo().getStartKey());
            }
        });
        List lgts = (List)top;
        lgts.sort(new Comparator<GeoTimeSerie>(){

            @Override
            public int compare(GeoTimeSerie o1, GeoTimeSerie o2) {
                return MetadataUtils.compare(o1.getMetadata(), o2.getMetadata());
            }
        });
        int gtsidx = 0;
        int regionidx = 0;
        ArrayList locations = new ArrayList();
        if (0 == lgts.size()) {
            stack.push(locations);
            return stack;
        }
        byte[] startrow = ((HRegionLocation)regions.get(regionidx)).getRegionInfo().getStartKey();
        byte[] endrow = ((HRegionLocation)regions.get(regionidx)).getRegionInfo().getEndKey();
        byte[] rowprefix = MetadataUtils.HBaseRowKeyPrefix(((GeoTimeSerie)lgts.get(gtsidx)).getMetadata());
        String selector = GTSHelper.buildSelector((GeoTimeSerie)lgts.get(gtsidx));
        while (gtsidx < lgts.size()) {
            while (regionidx < regions.size() && Bytes.compareTo((byte[])rowprefix, (int)0, (int)rowprefix.length, (byte[])endrow, (int)0, (int)rowprefix.length) > 0) {
                if (++regionidx >= regions.size()) continue;
                startrow = ((HRegionLocation)regions.get(regionidx)).getRegionInfo().getStartKey();
                endrow = ((HRegionLocation)regions.get(regionidx)).getRegionInfo().getEndKey();
            }
            if (regions.size() == regionidx) break;
            if (Bytes.compareTo((byte[])rowprefix, (int)0, (int)rowprefix.length, (byte[])startrow, (int)0, (int)rowprefix.length) >= 0) {
                ArrayList<String> location = new ArrayList<String>();
                location.add(selector);
                location.add(((HRegionLocation)regions.get(regionidx)).getHostnamePort().toString());
                location.add(((HRegionLocation)regions.get(regionidx)).getRegionInfo().getEncodedName());
                locations.add(location);
                if (Bytes.compareTo((byte[])rowprefix, (int)0, (int)rowprefix.length, (byte[])endrow, (int)0, (int)rowprefix.length) < 0) {
                    if (++gtsidx >= lgts.size()) continue;
                    rowprefix = MetadataUtils.HBaseRowKeyPrefix(((GeoTimeSerie)lgts.get(gtsidx)).getMetadata());
                    selector = GTSHelper.buildSelector((GeoTimeSerie)lgts.get(gtsidx));
                    continue;
                }
                if (++regionidx >= regions.size()) continue;
                startrow = ((HRegionLocation)regions.get(regionidx)).getRegionInfo().getStartKey();
                endrow = ((HRegionLocation)regions.get(regionidx)).getRegionInfo().getEndKey();
                continue;
            }
            if (++gtsidx >= lgts.size()) continue;
            rowprefix = MetadataUtils.HBaseRowKeyPrefix(((GeoTimeSerie)lgts.get(gtsidx)).getMetadata());
            selector = GTSHelper.buildSelector((GeoTimeSerie)lgts.get(gtsidx));
        }
        stack.push(locations);
        return stack;
    }
}

