/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.shadow;

import io.warp10.WarpConfig;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLib;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.FAIL;
import io.warp10.script.functions.NOOP;
import io.warp10.warp.sdk.WarpScriptExtension;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ShadowWarpScriptExtension
extends WarpScriptExtension {
    private static final String SHADOW_RENAME = "shadow.rename.";
    private static final String SHADOW_NOOP = "shadow.noop";
    private static final String SHADOW_FAIL = "shadow.fail";
    private static final String SHADOW_FAILMSG = "shadow.failmsg";
    private static final String SHADOW_UNDEF = "shadow.undef";
    private static final String SHADOW_MACRO = "shadow.macro";
    private static final String SHADOW_UNSAFEMACRO = "shadow.unsafemacro";
    private static final String SHADOW_MACROPREFIX = "shadow.macroprefix";
    private static final Map<String, Object> functions;

    @Override
    public Map<String, Object> getFunctions() {
        return functions;
    }

    static {
        Object func;
        functions = new HashMap<String, Object>();
        Properties properties = WarpConfig.getProperties();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(SHADOW_RENAME)) continue;
            String f = key.substring(SHADOW_RENAME.length());
            String target = WarpConfig.getProperty(key);
            String[] from = WarpScriptLib.getFunction(f);
            functions.put(target, from);
            functions.put(f, null);
        }
        String conf = WarpConfig.getProperty(SHADOW_MACRO);
        if (null != conf) {
            String[] func2;
            Object prefix = WarpConfig.getProperty(SHADOW_MACROPREFIX);
            boolean globalUnsafe = "true".equals(WarpConfig.getProperty(SHADOW_UNSAFEMACRO));
            prefix = null == prefix ? "" : (String)prefix + "/";
            for (String f : func2 = conf.split(",")) {
                f = f.trim();
                boolean unsafe = globalUnsafe;
                if (null != WarpConfig.getProperty("shadow.unsafemacro." + f)) {
                    unsafe = "true".equals(WarpConfig.getProperty("shadow.unsafemacro." + f));
                }
                final boolean finalUnsafe = unsafe;
                final String macro = (String)prefix + f;
                ShadowFunction function = new ShadowFunction(f){

                    @Override
                    public Object apply(WarpScriptStack stack) throws WarpScriptException {
                        if (!finalUnsafe) {
                            stack.save();
                        }
                        try {
                            if (!finalUnsafe) {
                                stack.forget(macro);
                            }
                            WarpScriptStack.Macro m = stack.find(macro);
                            stack.exec(m);
                        }
                        finally {
                            if (!finalUnsafe) {
                                stack.restore();
                            }
                        }
                        return stack;
                    }
                };
                functions.put(f, function);
            }
        }
        for (String key : properties.stringPropertyNames()) {
            boolean globalUnsafe;
            if (!key.startsWith("shadow.macro.")) continue;
            String f = key.substring(SHADOW_MACRO.length() + 1);
            boolean unsafe = globalUnsafe = "true".equals(WarpConfig.getProperty(SHADOW_UNSAFEMACRO));
            if (null != WarpConfig.getProperty("shadow.unsafemacro." + f)) {
                unsafe = "true".equals(WarpConfig.getProperty("shadow.unsafemacro." + f));
            }
            final boolean finalUnsafe = unsafe;
            final String macro = properties.getProperty(key);
            ShadowFunction function = new ShadowFunction(f){

                @Override
                public Object apply(WarpScriptStack stack) throws WarpScriptException {
                    if (!finalUnsafe) {
                        stack.save();
                    }
                    try {
                        if (!finalUnsafe) {
                            stack.forget(macro);
                        }
                        WarpScriptStack.Macro m = stack.find(macro);
                        stack.exec(m);
                    }
                    finally {
                        if (!finalUnsafe) {
                            stack.restore();
                        }
                    }
                    return stack;
                }
            };
            functions.put(f, function);
        }
        conf = WarpConfig.getProperty(SHADOW_NOOP);
        if (null != conf) {
            func = conf.split(",");
            for (String f : func) {
                f = f.trim();
                functions.put(f, new NOOP(f));
            }
        }
        if (null != (conf = WarpConfig.getProperty(SHADOW_FAIL))) {
            func = conf.split(",");
            final String msg = WarpConfig.getProperty(SHADOW_FAILMSG);
            for (Object f : func) {
                Object fu = f = ((String)f).trim();
                if (null == msg) {
                    functions.put((String)f, new FAIL((String)f));
                    continue;
                }
                ShadowFunction function = new ShadowFunction((String)f){

                    @Override
                    public Object apply(WarpScriptStack stack) throws WarpScriptException {
                        throw new WarpScriptException(msg);
                    }
                };
                functions.put((String)f, function);
            }
        }
        func = properties.stringPropertyNames().iterator();
        while (func.hasNext()) {
            String key = (String)func.next();
            if (!key.startsWith("shadow.fail.")) continue;
            String f = key.substring(SHADOW_FAIL.length() + 1);
            final String failmsg = properties.getProperty(key);
            ShadowFunction function = new ShadowFunction(f){

                @Override
                public Object apply(WarpScriptStack stack) throws WarpScriptException {
                    throw new WarpScriptException(failmsg);
                }
            };
            functions.put(f, function);
        }
        conf = WarpConfig.getProperty(SHADOW_UNDEF);
        if (null != conf) {
            for (Object f : func = conf.split(",")) {
                f = ((String)f).trim();
                functions.put((String)f, null);
            }
        }
    }

    public static class ShadowFunction
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public ShadowFunction(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            return stack;
        }
    }
}

