/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.urlfetch;

import io.warp10.WarpConfig;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.WebAccessController;
import io.warp10.script.ext.urlfetch.UrlFetchWarpScriptExtension;
import io.warp10.standalone.StandaloneWebCallService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.binary.Base64;

public class URLFETCH
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final ReentrantLock stackCountersLock = new ReentrantLock();
    private final WebAccessController webAccessController;

    public URLFETCH(String name) {
        super(name);
        String patternConf = WarpConfig.getProperty("warpscript.urlfetch.host.patterns");
        this.webAccessController = null == patternConf ? StandaloneWebCallService.getWebAccessController() : new WebAccessController(patternConf);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        AtomicLong urlfetchSize;
        AtomicLong urlfetchCount;
        if (!stack.isAuthenticated()) {
            throw new WarpScriptException(this.getName() + " requires the stack to be authenticated.");
        }
        Object o = stack.pop();
        if (!(o instanceof String) && !(o instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a URL or list thereof on top of the stack.");
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            if (o instanceof String) {
                urls.add(new URL(o.toString()));
            } else {
                for (Object oo : (List)o) {
                    urls.add(new URL(oo.toString()));
                }
            }
        }
        catch (MalformedURLException mue) {
            throw new WarpScriptException(this.getName() + " encountered an invalid URL.", mue);
        }
        for (URL url : urls) {
            if (this.webAccessController.checkURL(url)) continue;
            throw new WarpScriptException(this.getName() + " encountered a forbidden URL '" + url + "'");
        }
        try {
            this.stackCountersLock.lockInterruptibly();
            Object ufCount = stack.getAttribute("urlfetch.count");
            Object ufSize = stack.getAttribute("urlfetch.size");
            if (null == ufCount || null == ufSize) {
                urlfetchCount = new AtomicLong();
                urlfetchSize = new AtomicLong();
                stack.setAttribute("urlfetch.count", urlfetchCount);
                stack.setAttribute("urlfetch.size", urlfetchSize);
            } else {
                urlfetchCount = (AtomicLong)ufCount;
                urlfetchSize = (AtomicLong)ufSize;
            }
        }
        catch (InterruptedException ie) {
            throw new WarpScriptException(this.getName() + " thread has been interrupted", ie);
        }
        finally {
            if (this.stackCountersLock.isHeldByCurrentThread()) {
                this.stackCountersLock.unlock();
            }
        }
        if (urlfetchCount.get() + (long)urls.size() > UrlFetchWarpScriptExtension.getLongAttribute(stack, "urlfetch.limit")) {
            throw new WarpScriptException(this.getName() + " is limited to " + UrlFetchWarpScriptExtension.getLongAttribute(stack, "urlfetch.limit") + " calls.");
        }
        ArrayList results = new ArrayList();
        for (URL url : urls) {
            if (urlfetchCount.addAndGet(1L) > UrlFetchWarpScriptExtension.getLongAttribute(stack, "urlfetch.limit")) {
                throw new WarpScriptException(this.getName() + " is limited to " + UrlFetchWarpScriptExtension.getLongAttribute(stack, "urlfetch.limit") + " calls.");
            }
            HttpURLConnection conn = null;
            try {
                int len;
                conn = (HttpURLConnection)url.openConnection();
                if (null != url.getUserInfo()) {
                    String basicAuth = "Basic " + new String(Base64.encodeBase64String((byte[])url.getUserInfo().getBytes(StandardCharsets.UTF_8)));
                    conn.setRequestProperty("Authorization", basicAuth);
                }
                conn.setDoInput(true);
                conn.setDoOutput(false);
                conn.setRequestMethod("GET");
                byte[] buf = new byte[8192];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream in = null;
                try {
                    in = conn.getInputStream();
                }
                catch (IOException ioe) {
                    in = conn.getErrorStream();
                }
                while ((len = in.read(buf)) >= 0) {
                    if (urlfetchSize.get() + (long)baos.size() + (long)len > UrlFetchWarpScriptExtension.getLongAttribute(stack, "urlfetch.maxsize")) {
                        throw new WarpScriptException(this.getName() + " would exceed maximum size of content which can be retrieved via URLFETCH (" + UrlFetchWarpScriptExtension.getLongAttribute(stack, "urlfetch.maxsize") + " bytes)");
                    }
                    baos.write(buf, 0, len);
                }
                urlfetchSize.addAndGet(baos.size());
                ArrayList<Object> res = new ArrayList<Object>();
                res.add(conn.getResponseCode());
                Map<String, List<String>> hdrs = conn.getHeaderFields();
                if (hdrs.containsKey(null)) {
                    List<String> statusMsg = hdrs.get(null);
                    if (statusMsg.size() > 0) {
                        res.add(statusMsg.get(0));
                    } else {
                        res.add("");
                    }
                } else {
                    res.add("");
                }
                hdrs = new HashMap<String, List<String>>(hdrs);
                hdrs.remove(null);
                res.add(hdrs);
                res.add(Base64.encodeBase64String((byte[])baos.toByteArray()));
                results.add(res);
            }
            catch (IOException ioe) {
                throw new WarpScriptException(this.getName() + " encountered an error while fetching '" + url + "'", ioe);
            }
            finally {
                if (null == conn) continue;
                conn.disconnect();
            }
        }
        stack.push(results);
        return stack;
    }
}

