/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.CSTORE;
import io.warp10.script.functions.LOAD;
import io.warp10.script.functions.NOOP;
import io.warp10.script.functions.POPR;
import io.warp10.script.functions.PUSHR;
import io.warp10.script.functions.STORE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ASREGS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final NOOP NOOP = new NOOP("NOOP");

    public ASREGS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of variable names on top of the stack.");
        }
        Object[] regs = stack.getRegisters();
        int nregs = regs.length;
        HashMap<String, Integer> varregs = new HashMap<String, Integer>();
        int regidx = 0;
        for (Object v : (List)top) {
            if (regidx >= nregs) break;
            if (!(v instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a list of variable names on top of the stack.");
            }
            if (null != varregs.get(v.toString())) continue;
            varregs.put(v.toString(), regidx);
            ++regidx;
        }
        WarpScriptStackFunction[] regfuncs = new WarpScriptStackFunction[regidx * 3];
        for (int i = 0; i < regidx; ++i) {
            regfuncs[i] = new PUSHR("PUSHR" + i, i);
            regfuncs[regidx + i] = new POPR("POPR" + i, i);
            regfuncs[regidx + regidx + i] = new POPR("POPR" + i, i, true);
        }
        top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a macro.");
        }
        ArrayList<WarpScriptStack.Macro> allmacros = new ArrayList<WarpScriptStack.Macro>();
        allmacros.add((WarpScriptStack.Macro)top);
        boolean abort = false;
        while (!abort && !allmacros.isEmpty()) {
            WarpScriptStack.Macro m = (WarpScriptStack.Macro)allmacros.remove(0);
            ArrayList<Object> statements = new ArrayList<Object>(m.statements());
            for (int i = 0; i < statements.size(); ++i) {
                Integer regno;
                Object symbol;
                if (statements.get(i) instanceof WarpScriptStack.Macro) {
                    allmacros.add((WarpScriptStack.Macro)statements.get(i));
                    continue;
                }
                if (statements.get(i) instanceof LOAD) {
                    symbol = statements.get(i - 1);
                    if (!(symbol instanceof String)) {
                        abort = true;
                        break;
                    }
                    regno = (Integer)varregs.get(symbol.toString());
                    if (null == regno) continue;
                    statements.set(i - 1, NOOP);
                    statements.set(i, regfuncs[regno]);
                    continue;
                }
                if (statements.get(i) instanceof STORE) {
                    symbol = statements.get(i - 1);
                    if (!(symbol instanceof String)) {
                        abort = true;
                        break;
                    }
                    regno = (Integer)varregs.get(symbol.toString());
                    if (null == regno) continue;
                    statements.set(i - 1, NOOP);
                    statements.set(i, regfuncs[regno + regidx]);
                    continue;
                }
                if (!(statements.get(i) instanceof CSTORE)) continue;
                symbol = statements.get(i - 1);
                if (!(symbol instanceof String)) {
                    abort = true;
                    break;
                }
                regno = (Integer)varregs.get(symbol.toString());
                if (null == regno) continue;
                statements.set(i - 1, NOOP);
                statements.set(i, regfuncs[regno + regidx + regidx]);
            }
            if (abort) continue;
            List<Object> macstmt = m.statements();
            int noops = 0;
            for (int i = 0; i < statements.size(); ++i) {
                if (statements.get(i) instanceof NOOP) {
                    ++noops;
                    continue;
                }
                macstmt.set(i - noops, statements.get(i));
            }
            m.setSize(statements.size() - noops);
        }
        if (abort) {
            throw new WarpScriptException(this.getName() + " was unable to convert variables to registers.");
        }
        stack.push(top);
        return stack;
    }
}

