/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.DoubleUtils;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class DTW
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean normalize;
    private final boolean znormalize;

    public DTW(String name, boolean normalize, boolean znormalize) {
        super(name);
        this.normalize = normalize;
        this.znormalize = znormalize;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a numeric threshold on top of the stack.");
        }
        double threshold = ((Number)o).doubleValue();
        o = stack.pop();
        if (!(o instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " expects two Geo Time Series below the threshold.");
        }
        GeoTimeSerie gts1 = (GeoTimeSerie)o;
        o = stack.pop();
        if (!(o instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " expects two Geo Time Series below the threshold.");
        }
        GeoTimeSerie gts2 = (GeoTimeSerie)o;
        stack.push(this.compute(gts1, gts2, threshold));
        return stack;
    }

    public final double compute(GeoTimeSerie gts1, GeoTimeSerie gts2, double threshold) throws WarpScriptException {
        double[] values2;
        double[] values1;
        block14: {
            if (GeoTimeSerie.TYPE.LONG != gts1.getType() && GeoTimeSerie.TYPE.DOUBLE != gts1.getType()) {
                throw new WarpScriptException(this.getName() + " can only operate on numerical Geo Time Series.");
            }
            if (GeoTimeSerie.TYPE.LONG != gts2.getType() && GeoTimeSerie.TYPE.DOUBLE != gts2.getType()) {
                throw new WarpScriptException(this.getName() + " can only operate on numerical Geo Time Series.");
            }
            GTSHelper.sort(gts1);
            GTSHelper.sort(gts2);
            values1 = GTSHelper.getValuesAsDouble(gts1);
            values2 = GTSHelper.getValuesAsDouble(gts2);
            if (!this.normalize) break block14;
            if (this.znormalize) {
                int i;
                double[] musigma = DoubleUtils.musigma(values1, true);
                for (i = 0; i < values1.length; ++i) {
                    values1[i] = (values1[i] - musigma[0]) / musigma[1];
                }
                musigma = DoubleUtils.muvar(values2);
                for (i = 0; i < values2.length; ++i) {
                    values2[i] = (values2[i] - musigma[0]) / musigma[1];
                }
            } else {
                int i;
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                for (int i2 = 0; i2 < values1.length; ++i2) {
                    if (values1[i2] < min) {
                        min = values1[i2];
                    }
                    if (!(values1[i2] > max)) continue;
                    max = values1[i2];
                }
                if (min == max) {
                    throw new WarpScriptException(this.getName() + " cannot (yet) operate on constant GTS.");
                }
                double range = max - min;
                for (i = 0; i < values1.length; ++i) {
                    values1[i] = (values1[i] - min) / range;
                }
                min = Double.POSITIVE_INFINITY;
                max = Double.NEGATIVE_INFINITY;
                for (i = 0; i < values2.length; ++i) {
                    if (values2[i] < min) {
                        min = values2[i];
                    }
                    if (!(values2[i] > max)) continue;
                    max = values2[i];
                }
                if (min == max) {
                    throw new WarpScriptException(this.getName() + " cannot (yet) operate on constant GTS.");
                }
                range = max - min;
                for (i = 0; i < values2.length; ++i) {
                    values2[i] = (values2[i] - min) / range;
                }
            }
        }
        return this.compute(values1, 0, values1.length, values2, 0, values2.length, threshold);
    }

    public double compute(double[] values1, int offset1, int len1, double[] values2, int offset2, int len2, double threshold) {
        return this.compute(values1, offset1, len1, values2, offset2, len2, threshold, true);
    }

    public double compute(double[] values1, int offset1, int len1, double[] values2, int offset2, int len2, double threshold, boolean manhattan) {
        if (len1 > len2) {
            double[] tmp = values1;
            values1 = values2;
            values2 = tmp;
            int tmpint = offset1;
            offset1 = offset2;
            offset2 = tmpint;
            tmpint = len1;
            len1 = len2;
            len2 = tmpint;
        }
        double[] a = new double[len1];
        double[] b = new double[len1];
        int w = values2.length;
        boolean belowThreshold = false;
        for (int i = 0; i < len2; ++i) {
            int start = Math.max(0, i - w);
            int end = Math.min(len1 - 1, i + w);
            belowThreshold = false;
            for (int j = start; j <= end; ++j) {
                double d = manhattan ? Math.abs(values1[offset1 + j] - values2[offset2 + i]) : Math.pow(values1[offset1 + j] - values2[offset2 + i], 2.0);
                double left = a[j];
                double bottom = j > start ? b[j - 1] : Double.POSITIVE_INFINITY;
                double sw = j > start ? a[j - 1] : Double.POSITIVE_INFINITY;
                b[j] = d + Math.min(left, Math.min(bottom, sw));
                if (belowThreshold || 0.0 != threshold && !(b[j] <= threshold)) continue;
                belowThreshold = true;
            }
            if (!belowThreshold) break;
            double[] tmp = a;
            a = b;
            b = tmp;
        }
        if (!belowThreshold) {
            return -1.0;
        }
        double dtwDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < dtwDist)) continue;
            dtwDist = a[i];
        }
        if (!manhattan) {
            dtwDist = Math.sqrt(dtwDist);
        }
        return dtwDist;
    }
}

