/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DWTSPLIT
extends GTSStackFunction {
    private static final String LEVEL_LABEL = "levellabel";

    public DWTSPLIT(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a level label name on top of the stack.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(LEVEL_LABEL, top.toString());
        return params;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        String levellabel = params.get(LEVEL_LABEL).toString();
        if (GeoTimeSerie.TYPE.DOUBLE != gts.getType()) {
            throw new WarpScriptException(this.getName() + " can only be applied to numeric Geo Time Series.");
        }
        int len = gts.size();
        if (0 != (len & len - 1)) {
            throw new WarpScriptException(this.getName() + " can only operate on Geo Time Series whose length is a power of 2.");
        }
        if (gts.getLabels().containsKey(levellabel)) {
            throw new WarpScriptException(this.getName() + " input cannot contain label '" + levellabel + "'");
        }
        GTSHelper.sort(gts);
        int levels = 0;
        for (int tmp = len >> 1; tmp != 0; tmp >>>= 1) {
            ++levels;
        }
        int idx = 0;
        ArrayList<GeoTimeSerie> result = new ArrayList<GeoTimeSerie>();
        for (int level = 0; level < levels; ++level) {
            int levellen = 1 << level;
            GeoTimeSerie levelgts = new GeoTimeSerie(levellen);
            levelgts.setMetadata(gts.getMetadata());
            levelgts.getMetadata().putToLabels(levellabel, Integer.toString(levels - level));
            result.add(levelgts);
            while (levellen > 0) {
                GTSHelper.setValue(levelgts, GTSHelper.tickAtIndex(gts, idx), GTSHelper.locationAtIndex(gts, idx), GTSHelper.elevationAtIndex(gts, idx), GTSHelper.valueAtIndex(gts, idx), false);
                --levellen;
                ++idx;
            }
        }
        return result;
    }
}

