/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ENCODERTO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public ENCODERTO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        GTSDecoder decoder;
        Object top = stack.pop();
        if (!(top instanceof String || top instanceof byte[] || top instanceof GTSEncoder)) {
            throw new WarpScriptException(this.getName() + " operates on a string, byte array or encoder.");
        }
        ArrayList elements = new ArrayList();
        if (top instanceof GTSEncoder) {
            decoder = ((GTSEncoder)top).getDecoder(true);
        } else {
            try {
                byte[] bytes = top instanceof String ? OrderPreservingBase64.decode(top.toString().getBytes(StandardCharsets.US_ASCII)) : (byte[])top;
                TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
                GTSWrapper wrapper = new GTSWrapper();
                deser.deserialize((TBase)wrapper, bytes);
                decoder = GTSWrapperHelper.fromGTSWrapperToGTSDecoder(wrapper);
            }
            catch (TException te) {
                throw new WarpScriptException(this.getName() + " failed to unwrap encoder.", te);
            }
        }
        while (decoder.next()) {
            ArrayList<Object> element = new ArrayList<Object>(5);
            element.add(decoder.getTimestamp());
            long location = decoder.getLocation();
            if (91480763316633925L == location) {
                element.add(Double.NaN);
                element.add(Double.NaN);
            } else {
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)location);
                element.add(latlon[0]);
                element.add(latlon[1]);
            }
            long elevation = decoder.getElevation();
            if (Long.MIN_VALUE == elevation) {
                element.add(Double.NaN);
            } else {
                element.add(elevation);
            }
            element.add(decoder.getBinaryValue());
            elements.add(element);
        }
        stack.push(decoder.getName());
        stack.push(decoder.getLabels());
        stack.push(decoder.getMetadata().getAttributes());
        stack.push(elements);
        return stack;
    }
}

