/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpDist;
import io.warp10.continuum.TimeSource;
import io.warp10.continuum.Tokens;
import io.warp10.continuum.egress.EgressFetchHandler;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.store.DirectoryClient;
import io.warp10.continuum.store.GTSDecoderIterator;
import io.warp10.continuum.store.MetadataIterator;
import io.warp10.continuum.store.StoreClient;
import io.warp10.continuum.store.thrift.data.DirectoryRequest;
import io.warp10.continuum.store.thrift.data.MetaSet;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.crypto.CryptoUtils;
import io.warp10.crypto.KeyStore;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.crypto.SipHashInline;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.LISTTO;
import io.warp10.script.functions.PARSESELECTOR;
import io.warp10.script.unary.TOTIMESTAMP;
import io.warp10.sensision.Sensision;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class FETCH
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String PARAM_CLASS = "class";
    public static final String PARAM_EXTRA = "extra";
    public static final String PARAM_LABELS = "labels";
    public static final String PARAM_SELECTOR = "selector";
    public static final String PARAM_SELECTORS = "selectors";
    public static final String PARAM_SELECTOR_PAIRS = "selpairs";
    public static final String PARAM_TOKEN = "token";
    public static final String PARAM_END = "end";
    public static final String PARAM_START = "start";
    public static final String PARAM_COUNT = "count";
    public static final String PARAM_TIMESPAN = "timespan";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_WRITE_TIMESTAMP = "wtimestamp";
    public static final String PARAM_SHOWUUID = "showuuid";
    public static final String PARAM_TYPEATTR = "typeattr";
    public static final String PARAM_METASET = "metaset";
    public static final String PARAM_GTS = "gts";
    public static final String PARAM_ACTIVE_AFTER = "active.after";
    public static final String PARAM_QUIET_AFTER = "quiet.after";
    public static final String POSTFETCH_HOOK = "postfetch";
    private DateTimeFormatter fmt = ISODateTimeFormat.dateTimeParser();
    private WarpScriptStackFunction listTo = new LISTTO("");
    private final boolean fromArchive;
    private final GeoTimeSerie.TYPE forcedType;
    private final long[] SIPHASH_CLASS;
    private final long[] SIPHASH_LABELS;
    private final byte[] AES_METASET;

    public FETCH(String name, boolean fromArchive, GeoTimeSerie.TYPE type) {
        super(name);
        this.fromArchive = fromArchive;
        this.forcedType = type;
        KeyStore ks = null;
        try {
            ks = WarpDist.getKeyStore();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null != ks) {
            this.SIPHASH_CLASS = SipHashInline.getKey(ks.getKey("warp.siphash.class"));
            this.SIPHASH_LABELS = SipHashInline.getKey(ks.getKey("warp.siphash.labels"));
            this.AES_METASET = ks.getKey("warp.aes.metasets");
        } else {
            this.SIPHASH_CLASS = null;
            this.SIPHASH_LABELS = null;
            this.AES_METASET = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.peek();
        Map<String, Object> params = null;
        if (top instanceof Map) {
            stack.pop();
            params = this.paramsFromMap(stack, (Map)top);
        }
        if (top instanceof List) {
            if (5 != ((List)top).size()) {
                stack.drop();
                throw new WarpScriptException(this.getName() + " expects 5 parameters.");
            }
            this.listTo.apply(stack);
            stack.drop();
        }
        if (null == params) {
            long timespan;
            long endts;
            params = new HashMap<String, Object>();
            Object oStop = stack.pop();
            Object oStart = stack.pop();
            if (oStart instanceof String && oStop instanceof String) {
                long stop;
                long start = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8) ? TOTIMESTAMP.parseTimestamp(oStart.toString()) : this.fmt.parseDateTime((String)oStart).getMillis() * Constants.TIME_UNITS_PER_MS;
                if (start < (stop = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8) ? TOTIMESTAMP.parseTimestamp(oStop.toString()) : this.fmt.parseDateTime((String)oStop).getMillis() * Constants.TIME_UNITS_PER_MS)) {
                    endts = stop;
                    timespan = stop - start;
                } else {
                    endts = start;
                    timespan = start - stop;
                }
            } else if (oStart instanceof Long && oStop instanceof Long) {
                endts = (Long)oStart;
                timespan = (Long)oStop;
            } else {
                throw new WarpScriptException("Invalid timespan specification.");
            }
            params.put(PARAM_END, endts);
            if (timespan < 0L) {
                if (Long.MIN_VALUE == timespan) {
                    ++timespan;
                }
                params.put(PARAM_COUNT, -timespan);
            } else {
                params.put(PARAM_TIMESPAN, timespan);
            }
            Object oLabelsSelector = stack.pop();
            if (!(oLabelsSelector instanceof Map)) {
                throw new WarpScriptException("Label selectors must be a map.");
            }
            HashMap labelSelectors = new HashMap((Map)oLabelsSelector);
            params.put(PARAM_LABELS, labelSelectors);
            Object oClassSelector = stack.pop();
            if (!(oClassSelector instanceof String)) {
                throw new WarpScriptException("Class selector must be a string.");
            }
            String classSelector = (String)oClassSelector;
            params.put(PARAM_CLASS, classSelector);
            Object oToken = stack.pop();
            if (!(oToken instanceof String)) {
                throw new WarpScriptException("Token must be a string.");
            }
            String token = (String)oToken;
            params.put(PARAM_TOKEN, token);
        }
        StoreClient gtsStore = stack.getStoreClient();
        DirectoryClient directoryClient = stack.getDirectoryClient();
        GeoTimeSerie base = null;
        GeoTimeSerie[] bases = null;
        String typelabel = (String)params.get(PARAM_TYPEATTR);
        if (null != typelabel) {
            bases = new GeoTimeSerie[5];
        }
        ReadToken rtoken = Tokens.extractReadToken(params.get(PARAM_TOKEN).toString());
        ArrayList<String> clsSels = new ArrayList<String>();
        ArrayList<Map<String, String>> lblsSels = new ArrayList<Map<String, String>>();
        MetaSet metaset = null;
        List<Object> metadatas = null;
        MetadataIterator iter = null;
        if (params.containsKey(PARAM_METASET)) {
            metaset = (MetaSet)params.get(PARAM_METASET);
            iter = metaset.getMetadatas().iterator();
        } else if (params.containsKey(PARAM_GTS)) {
            List metas = (List)params.get(PARAM_GTS);
            Iterator iterator = metas.iterator();
            while (iterator.hasNext()) {
                Metadata m = (Metadata)iterator.next();
                if (null == m.getLabels()) {
                    m.setLabels(new HashMap<String, String>());
                }
                m.getLabels().remove(".producer");
                m.getLabels().remove(".owner");
                m.getLabels().remove(".app");
                m.getLabels().putAll(Tokens.labelSelectorsFromReadToken(rtoken));
                if (m.getLabels().containsKey(".producer") && '=' == m.getLabels().get(".producer").charAt(0)) {
                    m.getLabels().put(".producer", m.getLabels().get(".producer").substring(1));
                } else if (m.getLabels().containsKey(".producer")) {
                    throw new WarpScriptException(this.getName() + " provided token is incompatible with '" + PARAM_GTS + "' parameter, expecting a single producer.");
                }
                if (!m.getLabels().containsKey(".owner") || '=' != m.getLabels().get(".owner").charAt(0)) {
                    throw new WarpScriptException(this.getName() + " provided token is incompatible with '" + PARAM_GTS + "' parameter, expecting a single owner.");
                }
                m.getLabels().put(".owner", m.getLabels().get(".owner").substring(1));
                if (m.getLabels().containsKey(".app") && '=' == m.getLabels().get(".app").charAt(0)) {
                    m.getLabels().put(".app", m.getLabels().get(".app").substring(1));
                    continue;
                }
                throw new WarpScriptException(this.getName() + " provided token is incompatible with '" + PARAM_GTS + "' parameter, expecting a single application.");
            }
            iter = ((List)params.get(PARAM_GTS)).iterator();
        } else {
            if (params.containsKey(PARAM_SELECTOR_PAIRS)) {
                for (Pair pair : (List)params.get(PARAM_SELECTOR_PAIRS)) {
                    clsSels.add(pair.getLeft().toString());
                    Map labelSelectors = (Map)pair.getRight();
                    labelSelectors.putAll(Tokens.labelSelectorsFromReadToken(rtoken));
                    lblsSels.add(labelSelectors);
                }
            } else {
                Map labelSelectors = (Map)params.get(PARAM_LABELS);
                labelSelectors.putAll(Tokens.labelSelectorsFromReadToken(rtoken));
                clsSels.add(params.get(PARAM_CLASS).toString());
                lblsSels.add(labelSelectors);
            }
            DirectoryRequest drequest = new DirectoryRequest();
            drequest.setClassSelectors(clsSels);
            drequest.setLabelsSelectors(lblsSels);
            if (params.containsKey(PARAM_ACTIVE_AFTER)) {
                drequest.setActiveAfter((Long)params.get(PARAM_ACTIVE_AFTER));
            }
            if (params.containsKey(PARAM_QUIET_AFTER)) {
                drequest.setQuietAfter((Long)params.get(PARAM_QUIET_AFTER));
            }
            try {
                metadatas = directoryClient.find(drequest);
                iter = metadatas.iterator();
            }
            catch (IOException ioe) {
                try {
                    iter = directoryClient.iterator(drequest);
                }
                catch (Exception e) {
                    throw new WarpScriptException(e);
                }
            }
        }
        metadatas = new ArrayList();
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        AtomicLong fetched = (AtomicLong)stack.getAttribute("fetch.count");
        long fetchLimit = (Long)stack.getAttribute("fetch.limit");
        long gtsLimit = (Long)stack.getAttribute("gts.limit");
        AtomicLong gtscount = (AtomicLong)stack.getAttribute("gts.count");
        Metadata lastMetadata = null;
        long lastCount = 0L;
        try {
            while (iter.hasNext()) {
                metadatas.add(iter.next());
                if (gtscount.incrementAndGet() > gtsLimit) {
                    throw new WarpScriptException(this.getName() + " exceeded limit of " + gtsLimit + " Geo Time Series, current count is " + gtscount);
                }
                if ((long)metadatas.size() < EgressFetchHandler.FETCH_BATCHSIZE && iter.hasNext()) continue;
                if (params.containsKey(PARAM_EXTRA)) {
                    HashSet<Object> withextra = new HashSet<Object>();
                    withextra.addAll(metadatas);
                    for (Metadata metadata : metadatas) {
                        for (String cls : (Set)params.get(PARAM_EXTRA)) {
                            Metadata metadata2 = new Metadata(metadata);
                            metadata2.setName(cls);
                            metadata2.setClassId(GTSHelper.classId(this.SIPHASH_CLASS, cls));
                            metadata2.setLabelsId(GTSHelper.labelsId(this.SIPHASH_LABELS, metadata2.getLabels()));
                            withextra.add(metadata2);
                        }
                    }
                    metadatas.clear();
                    metadatas.addAll(withextra);
                }
                long timespan = params.containsKey(PARAM_TIMESPAN) ? (Long)params.get(PARAM_TIMESPAN) : -((Long)params.get(PARAM_COUNT)).longValue();
                GeoTimeSerie.TYPE tYPE = (GeoTimeSerie.TYPE)((Object)params.get(PARAM_TYPE));
                if (null != this.forcedType) {
                    if (null != tYPE) {
                        throw new WarpScriptException(this.getName() + " type of fetched GTS cannot be changed.");
                    }
                    GeoTimeSerie.TYPE tYPE2 = this.forcedType;
                }
                boolean writeTimestamp = Boolean.TRUE.equals(params.get(PARAM_WRITE_TIMESTAMP));
                boolean showUUID = Boolean.TRUE.equals(params.get(PARAM_SHOWUUID));
                GeoTimeSerie.TYPE lastType = GeoTimeSerie.TYPE.UNDEFINED;
                try (GTSDecoderIterator gtsiter = gtsStore.fetch(rtoken, metadatas, (Long)params.get(PARAM_END), timespan, this.fromArchive, writeTimestamp);){
                    while (gtsiter.hasNext()) {
                        GeoTimeSerie gts;
                        void var27_34;
                        UUID uuid;
                        GTSDecoder decoder = (GTSDecoder)gtsiter.next();
                        boolean identical = true;
                        if (null == lastMetadata || !lastMetadata.equals(decoder.getMetadata())) {
                            lastMetadata = decoder.getMetadata();
                            identical = false;
                            lastCount = 0L;
                            lastType = GeoTimeSerie.TYPE.UNDEFINED;
                        }
                        if (null != typelabel) {
                            uuid = null;
                            if (showUUID) {
                                uuid = new UUID(decoder.getClassId(), decoder.getLabelsId());
                            }
                            long count = 0L;
                            Metadata decoderMeta = new Metadata(decoder.getMetadata());
                            decoderMeta.getLabels().remove(".producer");
                            decoderMeta.getLabels().remove(".owner");
                            while (decoder.next() && (timespan >= 0L || lastCount + count < -timespan)) {
                                ++count;
                                long ts = decoder.getTimestamp();
                                long location = decoder.getLocation();
                                long elevation = decoder.getElevation();
                                Object value = decoder.getBinaryValue();
                                int gtsidx = 0;
                                String typename = "DOUBLE";
                                if (value instanceof Long) {
                                    gtsidx = 1;
                                    typename = "LONG";
                                } else if (value instanceof Boolean) {
                                    gtsidx = 2;
                                    typename = "BOOLEAN";
                                } else if (value instanceof String) {
                                    gtsidx = 3;
                                    typename = "STRING";
                                } else if (value instanceof byte[]) {
                                    gtsidx = 4;
                                    typename = "BINARY";
                                }
                                base = bases[gtsidx];
                                if (null == base || !base.getMetadata().getName().equals(decoderMeta.getName()) || !base.getMetadata().getLabels().equals(decoderMeta.getLabels())) {
                                    bases[gtsidx] = new GeoTimeSerie();
                                    base = bases[gtsidx];
                                    series.add(base);
                                    base.setMetadata(decoderMeta);
                                    base.getMetadata().putToAttributes(typelabel, typename);
                                    if (null != uuid) {
                                        base.getMetadata().putToAttributes(".uuid", uuid.toString());
                                    }
                                }
                                GTSHelper.setValue(base, ts, location, elevation, value, false);
                            }
                            if (fetched.addAndGet(count) > fetchLimit) {
                                HashMap<String, String> sensisionLabels = new HashMap<String, String>();
                                sensisionLabels.put("consumer", Tokens.getUUID(rtoken.getBilledId()));
                                Sensision.update((String)"warp.script.fetchcount.exceeded", sensisionLabels, (Number)1);
                                throw new WarpScriptException(this.getName() + " exceeded limit of " + fetchLimit + " datapoints, current count is " + fetched.get());
                            }
                            lastCount += count;
                            continue;
                        }
                        if (null != var27_34) {
                            gts = decoder.decode((GeoTimeSerie.TYPE)var27_34);
                        } else {
                            gts = identical && lastType != GeoTimeSerie.TYPE.UNDEFINED ? decoder.decode(lastType) : decoder.decode();
                            lastType = gts.getType();
                        }
                        if (timespan < 0L && lastCount + (long)GTSHelper.nvalues(gts) > -timespan) {
                            gts = GTSHelper.shrinkTo(gts, (int)Math.max(-timespan - lastCount, 0L));
                        }
                        lastCount += (long)GTSHelper.nvalues(gts);
                        if (showUUID) {
                            uuid = new UUID(gts.getClassId(), gts.getLabelsId());
                            gts.getMetadata().putToAttributes(".uuid", uuid.toString());
                        }
                        HashMap<String, String> labels = new HashMap<String, String>();
                        labels.putAll(gts.getMetadata().getLabels());
                        labels.remove(".producer");
                        labels.remove(".owner");
                        gts.setLabels(labels);
                        if (null == base) {
                            base = gts;
                        } else if (!base.getMetadata().getName().equals(gts.getMetadata().getName()) || !base.getMetadata().getLabels().equals(gts.getMetadata().getLabels())) {
                            series.add(base);
                            base = gts;
                        } else {
                            base = GTSHelper.merge(base, gts);
                        }
                        if (fetched.addAndGet(gts.size()) <= fetchLimit) continue;
                        HashMap<String, String> sensisionLabels = new HashMap<String, String>();
                        sensisionLabels.put("consumer", Tokens.getUUID(rtoken.getBilledId()));
                        Sensision.update((String)"warp.script.fetchcount.exceeded", sensisionLabels, (Number)1);
                        throw new WarpScriptException(this.getName() + " exceeded limit of " + fetchLimit + " datapoints, current count is " + fetched.get());
                    }
                }
                catch (WarpScriptException ee) {
                    throw ee;
                }
                catch (Throwable t) {
                    throw new WarpScriptException(t);
                }
                if (null != base && null == typelabel) {
                    series.add(base);
                }
                base = null;
                metadatas.clear();
            }
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            if (iter instanceof MetadataIterator) {
                try {
                    iter.close();
                }
                catch (Exception timespan) {}
            }
        }
        stack.push(series);
        if (rtoken.getHooksSize() > 0 && rtoken.getHooks().containsKey(POSTFETCH_HOOK)) {
            stack.execMulti(rtoken.getHooks().get(POSTFETCH_HOOK));
        }
        return stack;
    }

    private Map<String, Object> paramsFromMap(WarpScriptStack stack, Map<String, Object> map) throws WarpScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        MetaSet metaset = null;
        if (map.containsKey(PARAM_METASET)) {
            if (null == this.AES_METASET) {
                throw new WarpScriptException(this.getName() + " MetaSet support not available.");
            }
            Object ms = map.get(PARAM_METASET);
            if (!(ms instanceof byte[])) {
                byte[] decoded = OrderPreservingBase64.decode(ms.toString().getBytes(StandardCharsets.US_ASCII));
                byte[] decrypted = CryptoUtils.unwrap(this.AES_METASET, decoded);
                try {
                    int len;
                    ByteArrayOutputStream out = new ByteArrayOutputStream(decrypted.length);
                    GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(decrypted));
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) >= 0) {
                        out.write(buf, 0, len);
                    }
                    ((InputStream)in).close();
                    out.close();
                    ms = out.toByteArray();
                }
                catch (IOException e) {
                    throw new WarpScriptException(this.getName() + " encountered an invalid MetaSet.", e);
                }
            }
            metaset = new MetaSet();
            TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
            try {
                deser.deserialize((TBase)metaset, (byte[])ms);
            }
            catch (TException te) {
                throw new WarpScriptException(this.getName() + " was unable to decode the provided MetaSet.", te);
            }
            if (metaset.getExpiry() < System.currentTimeMillis()) {
                throw new WarpScriptException(this.getName() + " MetaSet has expired.");
            }
            ReadToken rtoken = Tokens.extractReadToken(metaset.getToken());
            params.put(PARAM_METASET, metaset);
            params.put(PARAM_TOKEN, metaset.getToken());
        }
        if (!params.containsKey(PARAM_TOKEN)) {
            if (!map.containsKey(PARAM_TOKEN)) {
                throw new WarpScriptException(this.getName() + " Missing '" + PARAM_TOKEN + "' parameter");
            }
            params.put(PARAM_TOKEN, map.get(PARAM_TOKEN));
        }
        if (map.containsKey(PARAM_GTS)) {
            Object o = map.get(PARAM_GTS);
            if (!(o instanceof List)) {
                throw new WarpScriptException(this.getName() + " invalid '" + PARAM_GTS + "' parameter, expected a list of Geo Time Series.");
            }
            ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
            for (Object elt : (List)o) {
                if (!(elt instanceof GeoTimeSerie)) {
                    throw new WarpScriptException(this.getName() + " invalid '" + PARAM_GTS + "' parameter, expected a list of Geo Time Series.");
                }
                metadatas.add(new Metadata(((GeoTimeSerie)elt).getMetadata()));
            }
            params.put(PARAM_GTS, metadatas);
        }
        if (map.containsKey(PARAM_SELECTORS)) {
            Object sels = map.get(PARAM_SELECTORS);
            if (!(sels instanceof List)) {
                throw new WarpScriptException(this.getName() + " Invalid parameter '" + PARAM_SELECTORS + "'");
            }
            ArrayList<Pair> selectors = new ArrayList<Pair>();
            for (Object sel : (List)sels) {
                Object[] clslbls = PARSESELECTOR.parse(sel.toString());
                selectors.add(Pair.of((Object)clslbls[0], (Object)clslbls[1]));
            }
            params.put(PARAM_SELECTOR_PAIRS, selectors);
        } else if (map.containsKey(PARAM_SELECTOR)) {
            Object[] clslbls = PARSESELECTOR.parse(map.get(PARAM_SELECTOR).toString());
            params.put(PARAM_CLASS, clslbls[0]);
            params.put(PARAM_LABELS, clslbls[1]);
        } else if (map.containsKey(PARAM_CLASS) && map.containsKey(PARAM_LABELS)) {
            params.put(PARAM_CLASS, map.get(PARAM_CLASS));
            params.put(PARAM_LABELS, map.get(PARAM_LABELS));
        } else if (!params.containsKey(PARAM_METASET) && !params.containsKey(PARAM_GTS)) {
            throw new WarpScriptException(this.getName() + " Missing '" + PARAM_METASET + "', '" + PARAM_GTS + "', '" + PARAM_SELECTOR + "', '" + PARAM_SELECTORS + "' or '" + PARAM_CLASS + "' and '" + PARAM_LABELS + "' parameters.");
        }
        if (!map.containsKey(PARAM_END)) {
            throw new WarpScriptException(this.getName() + " Missing '" + PARAM_END + "' parameter.");
        }
        if (map.get(PARAM_END) instanceof Long) {
            params.put(PARAM_END, map.get(PARAM_END));
        } else if (map.get(PARAM_END) instanceof String) {
            if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8)) {
                params.put(PARAM_END, TOTIMESTAMP.parseTimestamp(map.get(PARAM_END).toString()));
            } else {
                params.put(PARAM_END, this.fmt.parseDateTime(map.get(PARAM_END).toString()).getMillis() * Constants.TIME_UNITS_PER_MS);
            }
        } else {
            throw new WarpScriptException(this.getName() + " Invalid format for parameter '" + PARAM_END + "'.");
        }
        if (map.containsKey(PARAM_TIMESPAN)) {
            params.put(PARAM_TIMESPAN, (Long)map.get(PARAM_TIMESPAN));
        } else if (map.containsKey(PARAM_COUNT)) {
            params.put(PARAM_COUNT, (Long)map.get(PARAM_COUNT));
        } else if (map.containsKey(PARAM_START)) {
            long timespan;
            long end = (Long)params.get(PARAM_END);
            long start = map.get(PARAM_START) instanceof Long ? (Long)map.get(PARAM_START) : (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8) ? TOTIMESTAMP.parseTimestamp(map.get(PARAM_START).toString()) : this.fmt.parseDateTime(map.get(PARAM_START).toString()).getMillis() * Constants.TIME_UNITS_PER_MS);
            if (start < end) {
                timespan = end - start;
            } else {
                timespan = start - end;
                end = start;
            }
            params.put(PARAM_END, end);
            params.put(PARAM_TIMESPAN, timespan);
        } else {
            throw new WarpScriptException(this.getName() + " Missing parameter '" + PARAM_TIMESPAN + "' or '" + PARAM_COUNT + "' or '" + PARAM_START + "'");
        }
        if (null != metaset) {
            long count;
            long end = (Long)params.get(PARAM_END);
            long timespan = params.containsKey(PARAM_TIMESPAN) ? (Long)params.get(PARAM_TIMESPAN) : -1L;
            long l = count = params.containsKey(PARAM_COUNT) ? (Long)params.get(PARAM_COUNT) : -1L;
            if (metaset.isSetMaxduration()) {
                params.put(PARAM_END, TimeSource.getTime());
                if (-1L != count && metaset.getMaxduration() >= 0L) {
                    throw new WarpScriptException(this.getName() + " MetaSet forbids count based requests.");
                }
                if (-1L != timespan && metaset.getMaxduration() <= 0L) {
                    throw new WarpScriptException(this.getName() + " MetaSet forbids duration based requests.");
                }
                if (-1L != count && count > -metaset.getMaxduration()) {
                    count = -metaset.getMaxduration();
                    params.put(PARAM_COUNT, count);
                }
                if (-1L != timespan && timespan > metaset.getMaxduration()) {
                    timespan = metaset.getMaxduration();
                    params.put(PARAM_TIMESPAN, timespan);
                }
            }
            if (metaset.isSetNotbefore()) {
                if (-1L != count) {
                    throw new WarpScriptException(this.getName() + " MetaSet forbids count based requests.");
                }
                if (end < metaset.getNotbefore()) {
                    throw new WarpScriptException(this.getName() + " MetaSet forbids time ranges before " + metaset.getNotbefore());
                }
                if (timespan > metaset.getMaxduration()) {
                    timespan = metaset.getMaxduration();
                    params.put(PARAM_TIMESPAN, timespan);
                }
            }
            if (metaset.isSetNotafter() && end >= metaset.getNotafter()) {
                end = metaset.getNotafter();
                params.put(PARAM_END, end);
            }
        }
        if (map.containsKey(PARAM_TYPE)) {
            String type = map.get(PARAM_TYPE).toString();
            if (GeoTimeSerie.TYPE.LONG.name().equalsIgnoreCase(type)) {
                params.put(PARAM_TYPE, (Object)GeoTimeSerie.TYPE.LONG);
            } else if (GeoTimeSerie.TYPE.DOUBLE.name().equalsIgnoreCase(type)) {
                params.put(PARAM_TYPE, (Object)GeoTimeSerie.TYPE.DOUBLE);
            } else if (GeoTimeSerie.TYPE.STRING.name().equalsIgnoreCase(type)) {
                params.put(PARAM_TYPE, (Object)GeoTimeSerie.TYPE.STRING);
            } else if (GeoTimeSerie.TYPE.BOOLEAN.name().equalsIgnoreCase(type)) {
                params.put(PARAM_TYPE, (Object)GeoTimeSerie.TYPE.BOOLEAN);
            } else {
                throw new WarpScriptException(this.getName() + " Invalid value for parameter '" + PARAM_TYPE + "'.");
            }
        }
        if (map.containsKey(PARAM_TYPEATTR)) {
            if (map.containsKey(PARAM_TYPE)) {
                throw new WarpScriptException(this.getName() + " Incompatible parameters '" + PARAM_TYPE + "' and '" + PARAM_TYPEATTR + "'.");
            }
            params.put(PARAM_TYPEATTR, map.get(PARAM_TYPEATTR).toString());
        }
        if (map.containsKey(PARAM_EXTRA)) {
            if (params.containsKey(PARAM_METASET)) {
                throw new WarpScriptException(this.getName() + " Cannot specify '" + PARAM_EXTRA + "' when '" + PARAM_METASET + "' is used.");
            }
            if (params.containsKey(PARAM_GTS)) {
                throw new WarpScriptException(this.getName() + " Cannot specify '" + PARAM_EXTRA + "' when '" + PARAM_GTS + "' is used.");
            }
            if (!(map.get(PARAM_EXTRA) instanceof List)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_EXTRA + "'.");
            }
            HashSet<String> extra = new HashSet<String>();
            for (Object o : (List)map.get(PARAM_EXTRA)) {
                if (!(o instanceof String)) {
                    throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_EXTRA + "'.");
                }
                extra.add(o.toString());
            }
            params.put(PARAM_EXTRA, extra);
        }
        if (map.containsKey(PARAM_WRITE_TIMESTAMP)) {
            params.put(PARAM_WRITE_TIMESTAMP, Boolean.TRUE.equals(map.get(PARAM_WRITE_TIMESTAMP)));
        }
        if (map.containsKey(PARAM_ACTIVE_AFTER)) {
            if (!(map.get(PARAM_ACTIVE_AFTER) instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_ACTIVE_AFTER + "'.");
            }
            params.put(PARAM_ACTIVE_AFTER, (Long)map.get(PARAM_ACTIVE_AFTER) / Constants.TIME_UNITS_PER_MS);
        }
        if (map.containsKey(PARAM_QUIET_AFTER)) {
            if (!(map.get(PARAM_QUIET_AFTER) instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + PARAM_QUIET_AFTER + "'.");
            }
            params.put(PARAM_QUIET_AFTER, (Long)map.get(PARAM_QUIET_AFTER) / Constants.TIME_UNITS_PER_MS);
        }
        if (map.containsKey(PARAM_SHOWUUID)) {
            params.put(PARAM_SHOWUUID, map.get(PARAM_SHOWUUID));
        }
        return params;
    }
}

