/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.vividsolutions.jts.geom.Geometry;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import org.wololo.jts2geojson.GeoJSONReader;

public class GeoJSON
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean uniform;

    public GeoJSON(String name, boolean uniform) {
        super(name);
        this.uniform = uniform;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long res;
        Object inside = stack.pop();
        Object pcterror = stack.pop();
        Object geoJson = stack.pop();
        if (!(geoJson instanceof String) || !(inside instanceof Boolean) || !(pcterror instanceof Double) && !(pcterror instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a GeoJSON string, an error percentage or resolution (even number between 2 and 30) and a boolean as the top 3 elements of the stack.");
        }
        if (pcterror instanceof Long && (1L == (res = ((Number)pcterror).longValue()) % 2L || res > 30L || res < 2L)) {
            throw new WarpScriptException(this.getName() + " expects the resolution to be an even number between 2 and 30");
        }
        GeoJSONReader reader = new GeoJSONReader();
        Geometry geometry = null;
        try {
            geometry = reader.read((String)geoJson);
        }
        catch (UnsupportedOperationException uoe) {
            throw new WarpScriptException(uoe);
        }
        int maxcells = ((Number)stack.getAttribute("stack.maxgeocells")).intValue();
        GeoXPLib.GeoXPShape shape = null;
        shape = !this.uniform ? (pcterror instanceof Double ? GeoXPLib.toGeoXPShape((Geometry)geometry, (double)((Number)pcterror).doubleValue(), (boolean)Boolean.TRUE.equals(inside), (int)maxcells) : GeoXPLib.toGeoXPShape((Geometry)geometry, (int)((Number)pcterror).intValue(), (boolean)Boolean.TRUE.equals(inside), (int)maxcells)) : (pcterror instanceof Double ? GeoXPLib.toUniformGeoXPShape((Geometry)geometry, (double)((Number)pcterror).doubleValue(), (boolean)Boolean.TRUE.equals(inside), (int)maxcells) : GeoXPLib.toUniformGeoXPShape((Geometry)geometry, (int)((Number)pcterror).intValue(), (boolean)Boolean.TRUE.equals(inside), (int)maxcells));
        if (null == shape) {
            throw new WarpScriptException("Maximum number of cells exceeded in a geographic shape (warpscript.maxgeocells=" + maxcells + ")");
        }
        stack.push(shape);
        return stack;
    }
}

