/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLib;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MAN
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String MAN_FORBIDDEN_CHARS = ".*[!%&\\(\\)\\*+/<=>\\[\\]^\\{\\|\\}~].*";
    private static Pattern manForbiddenCharsPattern = Pattern.compile(".*[!%&\\(\\)\\*+/<=>\\[\\]^\\{\\|\\}~].*");

    public MAN(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o;
        String functionname = null;
        if (0 < stack.depth() && (o = stack.pop()) instanceof String) {
            functionname = o.toString();
            if (!WarpScriptLib.getFunctionNames().contains(functionname)) {
                functionname = "";
            }
        }
        if (null == functionname) {
            stack.push("http://www.warp10.io/");
        } else if ("".equals(functionname)) {
            stack.push("Unknown function name, please check http://www.warp10.io/");
        } else {
            String docname = functionname;
            Matcher m = manForbiddenCharsPattern.matcher(functionname);
            if (m.matches() || "-".equals(functionname) || "pi".equals(functionname) || "PI".equals(functionname) || "e".equals(functionname) || "E".equals(functionname) || "Pfilter".equals(functionname)) {
                docname = new String(OrderPreservingBase64.encode(functionname.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            }
            stack.push("http://www.warp10.io/doc/" + docname);
        }
        return stack;
    }
}

