/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MAP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String PARAM_MAPPER = "mapper";
    private static final String PARAM_PREWINDOW = "pre";
    private static final String PARAM_POSTWINDOW = "post";
    private static final String PARAM_OCCURENCES = "occurences";
    private static final String PARAM_STEP = "step";
    private static final String PARAM_OVERRIDE = "override";
    private static final String PARAM_OUTPUTTICKS = "ticks";

    public MAP(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (top instanceof Map) {
            return this.applyWithParamsFromMap(stack, (Map)top);
        }
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list as input or a map of parameters on top of a list of GTS.");
        }
        List params = (List)top;
        if (5 > params.size()) {
            throw new WarpScriptException(this.getName() + " needs a list of at least 5 parameters as input.");
        }
        int nseries = 0;
        for (int i = 0; i < params.size() && (params.get(i) instanceof GeoTimeSerie || params.get(i) instanceof List); ++i) {
            ++nseries;
        }
        if (0 == nseries) {
            throw new WarpScriptException(this.getName() + " expects Geo Time Series or lists thereof as first parameters.");
        }
        if (!(params.get(nseries) instanceof WarpScriptMapperFunction) && !(params.get(nseries) instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects a mapper function or a macro after Geo Time Series.");
        }
        if (!(params.get(nseries + 1) instanceof Long && params.get(nseries + 2) instanceof Long && params.get(nseries + 3) instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects prewindow, postwindow and occurrences as 3 parameters following the mapper function.");
        }
        int step = 1;
        if (params.size() > nseries + 4) {
            if (!(params.get(nseries + 4) instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects a step parameter that is an integer number.");
            }
            step = ((Number)params.get(nseries + 4)).intValue();
            if (step <= 0) {
                throw new WarpScriptException(this.getName() + " expects a step parameter which is strictly positive.");
            }
        }
        boolean overrideTick = false;
        if (params.size() > nseries + 5) {
            if (!(params.get(nseries + 5) instanceof Boolean)) {
                throw new WarpScriptException(this.getName() + " expects a boolean as 'override tick' parameter.");
            }
            overrideTick = Boolean.TRUE.equals(params.get(nseries + 5));
        }
        ArrayList series = new ArrayList();
        for (int i = 0; i < nseries; ++i) {
            series.add(params.get(i));
        }
        stack.push(series);
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put(PARAM_MAPPER, params.get(nseries));
        mapParams.put(PARAM_PREWINDOW, params.get(nseries + 1));
        mapParams.put(PARAM_POSTWINDOW, params.get(nseries + 2));
        mapParams.put(PARAM_OCCURENCES, params.get(nseries + 3));
        mapParams.put(PARAM_STEP, Long.valueOf(step));
        mapParams.put(PARAM_OVERRIDE, overrideTick);
        return this.applyWithParamsFromMap(stack, mapParams);
    }

    private Object applyWithParamsFromMap(WarpScriptStack stack, Map<String, Object> params) throws WarpScriptException {
        if (!params.containsKey(PARAM_MAPPER)) {
            throw new WarpScriptException(this.getName() + " Missing '" + PARAM_MAPPER + "' parameter.");
        }
        Object mapper = params.get(PARAM_MAPPER);
        long prewindow = !params.containsKey(PARAM_PREWINDOW) ? 0L : (Long)params.get(PARAM_PREWINDOW);
        long postwindow = !params.containsKey(PARAM_POSTWINDOW) ? 0L : (Long)params.get(PARAM_POSTWINDOW);
        int occurrences = !params.containsKey(PARAM_OCCURENCES) ? 0 : (int)((Long)params.get(PARAM_OCCURENCES)).longValue();
        int step = !params.containsKey(PARAM_STEP) ? 1 : (int)((Long)params.get(PARAM_STEP)).longValue();
        boolean overrideTick = !params.containsKey(PARAM_OVERRIDE) ? false : (Boolean)params.get(PARAM_OVERRIDE);
        Object outputTicks = params.get(PARAM_OUTPUTTICKS);
        Object top = stack.pop();
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        if (top instanceof List) {
            for (Object o : (List)top) {
                if (o instanceof List) {
                    for (Object oo : (List)o) {
                        if (!(oo instanceof GeoTimeSerie)) {
                            throw new WarpScriptException(this.getName() + " operates on lists of Geo Time Series.");
                        }
                        series.add((GeoTimeSerie)oo);
                    }
                    continue;
                }
                if (!(o instanceof GeoTimeSerie)) {
                    throw new WarpScriptException(this.getName() + " operates on lists of Geo Time Series.");
                }
                series.add((GeoTimeSerie)o);
            }
        } else {
            if (!(top instanceof GeoTimeSerie)) {
                throw new WarpScriptException(this.getName() + " operates on lists of Geo Time Series.");
            }
            series.add((GeoTimeSerie)top);
        }
        ArrayList<Object> mapped = new ArrayList<Object>();
        for (GeoTimeSerie gts : series) {
            List<GeoTimeSerie> res = GTSHelper.map(gts, mapper, prewindow, postwindow, Math.abs(occurrences), occurrences < 0, step, overrideTick, mapper instanceof WarpScriptStack.Macro ? stack : null, (List)outputTicks);
            if (res.size() < 2) {
                mapped.addAll(res);
                continue;
            }
            mapped.add(res);
        }
        stack.push(mapped);
        return stack;
    }
}

