/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.math.BigDecimal;

public class NSUMSUMSQ
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public NSUMSUMSQ(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " expects a Geo Time Series instance on top of the stack.");
        }
        GeoTimeSerie gts = (GeoTimeSerie)o;
        int n = GTSHelper.nvalues(gts);
        if (GeoTimeSerie.TYPE.DOUBLE != gts.getType() && GeoTimeSerie.TYPE.LONG != gts.getType()) {
            throw new WarpScriptException(this.getName() + " can only compute mu and sigma for numerical series.");
        }
        BigDecimal sum = BigDecimal.valueOf(0.0);
        BigDecimal sumsq = BigDecimal.valueOf(0.0);
        for (int i = 0; i < n; ++i) {
            BigDecimal bd = GeoTimeSerie.TYPE.DOUBLE == gts.getType() ? BigDecimal.valueOf(((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue()) : BigDecimal.valueOf(((Number)GTSHelper.valueAtIndex(gts, i)).longValue());
            sum = sum.add(bd);
            sumsq = sumsq.add(bd.multiply(bd));
        }
        stack.push(n);
        stack.push(sum.doubleValue());
        stack.push(sumsq.doubleValue());
        return stack;
    }
}

