/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.CapacityExtractorOutputStream;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.io.IOException;

public class OPTIMIZE
extends ElementOrListStackFunction {
    public OPTIMIZE(String name) {
        super(name);
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a ratio on top of the stack.");
        }
        final double ratio = ((Number)top).doubleValue();
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                if (element instanceof GeoTimeSerie) {
                    GeoTimeSerie gts = (GeoTimeSerie)element;
                    GTSHelper.shrink(gts, ratio);
                    return gts;
                }
                if (element instanceof GTSEncoder) {
                    GTSEncoder encoder = (GTSEncoder)element;
                    if (encoder.size() > 0) {
                        CapacityExtractorOutputStream extractor = new CapacityExtractorOutputStream();
                        try {
                            encoder.writeTo(extractor);
                            if ((double)extractor.getCapacity() / (double)encoder.size() > ratio) {
                                encoder.resize(encoder.size());
                            }
                        }
                        catch (IOException ioe) {
                            throw new WarpScriptException(OPTIMIZE.this.getName() + " encountered an error while shrinking encoder.", ioe);
                        }
                    }
                    return encoder;
                }
                throw new WarpScriptException(OPTIMIZE.this.getName() + "  operates on a Geo Time Series or encoder instance or a list thereof.");
            }
        };
    }
}

