/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.QUATERNIONTO;

public class QROTATE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public QROTATE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a quaternion on top of the stack.");
        }
        Object zo = stack.pop();
        Object yo = stack.pop();
        Object xo = stack.pop();
        if (!(zo instanceof Double && yo instanceof Double && xo instanceof Double)) {
            throw new WarpScriptException(this.getName() + " operates on a vector whose x,y,z coordinates are doubles below the quaternion.");
        }
        double x = ((Number)xo).doubleValue();
        double y = ((Number)yo).doubleValue();
        double z = ((Number)zo).doubleValue();
        double[] q = QUATERNIONTO.fromQuaternion(((Number)top).longValue());
        double v0 = (1.0 - 2.0 * q[2] * q[2] - 2.0 * q[3] * q[3]) * x + 2.0 * (q[1] * q[2] + q[0] * q[3]) * y + 2.0 * (q[1] * q[3] - q[0] * q[2]) * z;
        double v1 = 2.0 * (q[1] * q[2] - q[0] * q[3]) * x + (1.0 - 2.0 * q[1] * q[1] - 2.0 * q[3] * q[3]) * y + 2.0 * (q[2] * q[3] + q[0] * q[1]) * z;
        double v2 = 2.0 * (q[1] * q[3] + q[0] * q[2]) * x + 2.0 * (q[2] * q[3] - q[0] * q[1]) * y + (1.0 - 2.0 * q[1] * q[1] - 2.0 * q[2] * q[2]) * z;
        stack.push(v0);
        stack.push(v1);
        stack.push(v2);
        return stack;
    }
}

