/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptReducerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class REDUCE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean flatten;

    public REDUCE(String name, boolean flatten) {
        super(name);
        this.flatten = flatten;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list as input.");
        }
        List params = (List)top;
        if (params.size() < 3) {
            throw new WarpScriptException(this.getName() + " expects at least 3 parameters.");
        }
        for (int i = 0; i < params.size() - 2; ++i) {
            if (params.get(i) instanceof List) continue;
            throw new WarpScriptException(this.getName() + " expects lists of Geo Time Series as first parameter.");
        }
        int labelsIndex = params.size() - 2;
        int reducerIndex = params.size() - 1;
        boolean overrideTick = false;
        if (params.get(params.size() - 1) instanceof Boolean) {
            --labelsIndex;
            --reducerIndex;
            overrideTick = (Boolean)params.get(params.size() - 1);
        }
        if (null != params.get(labelsIndex) && !(params.get(labelsIndex) instanceof Collection)) {
            throw new WarpScriptException(this.getName() + " expects a list of label names or null as parameter number " + (labelsIndex + 1) + ".");
        }
        if (null != params.get(labelsIndex)) {
            for (Object o : (Collection)params.get(labelsIndex)) {
                if (o instanceof String) continue;
                throw new WarpScriptException(this.getName() + " expects a list of label names as parameter number " + (labelsIndex + 1) + ".");
            }
        }
        if (!(params.get(reducerIndex) instanceof WarpScriptReducerFunction)) {
            throw new WarpScriptException(this.getName() + " expects a function as parameter number " + (reducerIndex + 1) + ".");
        }
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        Collection bylabels = (Collection)params.get(labelsIndex);
        for (int i = 0; i < labelsIndex; ++i) {
            for (Object o : (List)params.get(i)) {
                if (o instanceof GeoTimeSerie) {
                    series.add((GeoTimeSerie)o);
                    continue;
                }
                throw new WarpScriptException(this.getName() + " expects lists of Geo Time Series as first parameter.");
            }
        }
        if (this.flatten) {
            stack.push(GTSHelper.reduce((WarpScriptReducerFunction)params.get(reducerIndex), series, bylabels, overrideTick));
        } else {
            stack.push(GTSHelper.reduceUnflattened((WarpScriptReducerFunction)params.get(reducerIndex), series, bylabels, overrideTick));
        }
        return stack;
    }
}

