/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.oss.jarjar.org.bouncycastle.util.Arrays;
import io.warp10.continuum.gts.UnsafeString;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class REVERSE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean stable;

    public REVERSE(String name, boolean stable) {
        super(name);
        this.stable = stable;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        ArrayList top = stack.pop();
        if (!(top instanceof List || top instanceof String || top instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a list, byte array or String.");
        }
        if (top instanceof List) {
            if (!this.stable) {
                ArrayList l = new ArrayList();
                l.addAll(top);
                top = l;
            }
            Collections.reverse(top);
            stack.push(top);
        } else if (top instanceof String) {
            if (!this.stable) {
                top = new String(UnsafeString.getChars(((Object)top).toString()));
            }
            char[] chars = UnsafeString.getChars(((Object)top).toString());
            int i = 0;
            for (int j = chars.length - 1; i < j; ++i, --j) {
                char tmp = chars[i];
                chars[i] = chars[j];
                chars[j] = tmp;
            }
            stack.push(top);
        } else if (top instanceof byte[]) {
            byte[] data = (byte[])top;
            if (!this.stable) {
                data = Arrays.copyOf((byte[])data, (int)data.length);
            }
            int i = 0;
            for (int j = data.length - 1; i < j; ++i, --j) {
                byte tmp = data[i];
                data[i] = data[j];
                data[j] = tmp;
            }
            stack.push(data);
        }
        return stack;
    }
}

