/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.Map;

public class SETATTRIBUTES
extends ElementOrListStackFunction {
    public SETATTRIBUTES(String name) {
        super(name);
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a map of attributes as parameter.");
        }
        final Map attributesUpdate = (Map)top;
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                if (element instanceof GeoTimeSerie) {
                    GeoTimeSerie gts = (GeoTimeSerie)element;
                    Map newAttributes = SETATTRIBUTES.this.updateAttribute(gts.getMetadata().getAttributes(), attributesUpdate);
                    gts.getMetadata().setAttributes(newAttributes);
                    return gts;
                }
                if (element instanceof GTSEncoder) {
                    GTSEncoder encoder = (GTSEncoder)element;
                    Map newAttributes = SETATTRIBUTES.this.updateAttribute(encoder.getMetadata().getAttributes(), attributesUpdate);
                    encoder.getMetadata().setAttributes(newAttributes);
                    return encoder;
                }
                throw new WarpScriptException(SETATTRIBUTES.this.getName() + " expects a GeoTimeSeries, a GTSEncoder or a list thereof under the attribute map.");
            }
        };
    }

    private Map<String, String> updateAttribute(Map<String, String> originalAttributes, Map<?, ?> attributesUpdate) throws WarpScriptException {
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        if (!attributesUpdate.containsKey(null) && originalAttributes.size() > 0) {
            newAttributes.putAll(originalAttributes);
        }
        for (Map.Entry<?, ?> entry : attributesUpdate.entrySet()) {
            if (null == entry.getKey()) continue;
            if (!(entry.getKey() instanceof String) || null != entry.getValue() && !(entry.getValue() instanceof String)) {
                throw new WarpScriptException(this.getName() + " attribute key and value MUST be of type String.");
            }
            if (null == entry.getValue() || "".equals(entry.getValue())) {
                newAttributes.remove(entry.getKey());
                continue;
            }
            newAttributes.put((String)entry.getKey(), (String)entry.getValue());
        }
        return newAttributes;
    }
}

