/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.WarpURLEncoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.gts.UnsafeString;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.GEOPACK;
import io.warp10.script.functions.WRAP;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SNAPSHOT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static ThreadLocal<AtomicInteger> recursionDepth = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger();
        }
    };
    private static final int MAX_RECURSION_LEVEL = 16;
    private static final String uuid = UUID.randomUUID().toString();
    private final boolean snapshotSymbols;
    private final boolean toMark;
    private final boolean countbased;
    private final boolean compresswrappers;
    private final boolean pop;

    public SNAPSHOT(String name, boolean snapshotSymbols, boolean toMark, boolean pop, boolean countbased) {
        this(name, snapshotSymbols, toMark, pop, countbased, true);
    }

    public SNAPSHOT(String name, boolean snapshotSymbols, boolean toMark, boolean pop, boolean countbased, boolean compresswrappers) {
        super(name);
        this.snapshotSymbols = snapshotSymbols;
        this.toMark = toMark;
        this.pop = pop;
        this.countbased = countbased;
        this.compresswrappers = compresswrappers;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        int lastidx = 0;
        StringBuilder sb = new StringBuilder();
        if (this.countbased) {
            Object top = stack.pop();
            if (!(top instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects a number of stack levels to snapshot.");
            }
            lastidx = ((Number)top).intValue() - 1;
            if (lastidx > stack.depth() - 1) {
                lastidx = stack.depth() - 1;
            }
        } else if (!this.toMark) {
            lastidx = stack.depth() - 1;
        } else {
            int i;
            for (i = 0; i < stack.depth() && !(stack.get(i) instanceof WarpScriptStack.Mark); ++i) {
            }
            lastidx = i;
            if (lastidx >= stack.depth()) {
                throw new WarpScriptException(this.getName() + " expects a MARK on the stack.");
            }
        }
        for (int i = lastidx; i >= 0; --i) {
            if (this.toMark && lastidx == i) continue;
            Object o = stack.get(i);
            SNAPSHOT.addElement(this, sb, o);
        }
        if (this.snapshotSymbols) {
            for (Map.Entry<String, Object> entry : stack.getSymbolTable().entrySet()) {
                SNAPSHOT.addElement(this, sb, entry.getValue());
                SNAPSHOT.addElement(this, sb, entry.getKey());
                sb.append("STORE");
                sb.append(" ");
            }
            Object[] regs = stack.getRegisters();
            sb.append("CLEARREGS");
            sb.append(" ");
            for (int i = 0; i < regs.length; ++i) {
                if (null == regs[i]) continue;
                SNAPSHOT.addElement(this, sb, regs[i]);
                sb.append("POPR");
                sb.append(i);
                sb.append(" ");
            }
        }
        if (this.pop) {
            if (stack.depth() - 1 == lastidx) {
                stack.clear();
            } else {
                while (lastidx >= 0) {
                    stack.pop();
                    --lastidx;
                }
            }
        }
        stack.push(sb.toString());
        return stack;
    }

    public static void addElement(StringBuilder sb, Object o) throws WarpScriptException {
        SNAPSHOT.addElement(null, sb, o, false);
    }

    public static void addElement(StringBuilder sb, Object o, boolean readable) throws WarpScriptException {
        SNAPSHOT.addElement(null, sb, o, readable);
    }

    public static void addElement(SNAPSHOT snapshot, StringBuilder sb, Object o) throws WarpScriptException {
        SNAPSHOT.addElement(snapshot, sb, o, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addElement(SNAPSHOT snapshot, StringBuilder sb, Object o, boolean readable) throws WarpScriptException {
        block51: {
            AtomicInteger depth = null;
            try {
                depth = recursionDepth.get();
                if (depth.addAndGet(1) > 16) {
                    throw new WarpScriptException("Recursive data structures exceeded 16 levels.");
                }
                if (null == o) {
                    sb.append("NULL");
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof AtomicLong) {
                    sb.append("COUNTER");
                    sb.append(" ");
                    if (0L != ((AtomicLong)o).get()) {
                        sb.append(((AtomicLong)o).get());
                        sb.append(" ");
                        sb.append("COUNTERSET");
                        sb.append(" ");
                    }
                    break block51;
                }
                if (o instanceof Number) {
                    sb.append(o);
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof String) {
                    sb.append("'");
                    if (readable) {
                        SNAPSHOT.appendProcessedString(sb, o.toString());
                    } else {
                        try {
                            sb.append(WarpURLEncoder.encode(o.toString(), StandardCharsets.UTF_8));
                        }
                        catch (UnsupportedEncodingException uee) {
                            throw new WarpScriptException(uee);
                        }
                    }
                    sb.append("' ");
                    break block51;
                }
                if (o instanceof Boolean) {
                    if (Boolean.TRUE.equals(o)) {
                        sb.append("true ");
                    } else {
                        sb.append("false ");
                    }
                    break block51;
                }
                if (o instanceof GeoTimeSerie || o instanceof GTSEncoder) {
                    sb.append("'");
                    MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null, new Properties());
                    stack.maxLimits();
                    stack.push(o);
                    WRAP w = new WRAP("", false, null == snapshot ? true : snapshot.compresswrappers);
                    w.apply(stack);
                    sb.append(stack.pop());
                    sb.append("' ");
                    if (o instanceof GeoTimeSerie) {
                        sb.append("UNWRAP");
                    } else {
                        sb.append("UNWRAPENCODER");
                    }
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof Vector) {
                    if (readable) {
                        sb.append("[");
                        sb.append(" ");
                        for (Object oo : (Vector)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, readable);
                        }
                        sb.append("]");
                        sb.append(" ");
                    } else {
                        sb.append("[");
                        sb.append("]");
                        sb.append(" ");
                        for (Object oo : (Vector)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, readable);
                            sb.append("+!");
                            sb.append(" ");
                        }
                    }
                    sb.append("->V");
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof List) {
                    if (readable) {
                        sb.append("[");
                        sb.append(" ");
                        for (Object oo : (List)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, readable);
                        }
                        sb.append("]");
                        sb.append(" ");
                    } else {
                        sb.append("[");
                        sb.append("]");
                        sb.append(" ");
                        for (Object oo : (List)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, readable);
                            sb.append("+!");
                            sb.append(" ");
                        }
                    }
                    break block51;
                }
                if (o instanceof Set) {
                    if (readable) {
                        sb.append("[");
                        sb.append(" ");
                        for (Object oo : (Set)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, readable);
                        }
                        sb.append("]");
                        sb.append(" ");
                    } else {
                        sb.append("[");
                        sb.append("]");
                        sb.append(" ");
                        for (Object oo : (Set)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, readable);
                            sb.append("+!");
                            sb.append(" ");
                        }
                    }
                    sb.append("->SET");
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof Map) {
                    if (readable) {
                        sb.append("{");
                        sb.append(System.lineSeparator());
                        for (Map.Entry entry : ((Map)o).entrySet()) {
                            SNAPSHOT.addElement(snapshot, sb, entry.getKey(), readable);
                            SNAPSHOT.addElement(snapshot, sb, entry.getValue(), readable);
                            sb.append(System.lineSeparator());
                        }
                        sb.append("}");
                        sb.append(" ");
                    } else {
                        sb.append("{");
                        sb.append("}");
                        sb.append(" ");
                        for (Map.Entry entry : ((Map)o).entrySet()) {
                            SNAPSHOT.addElement(snapshot, sb, entry.getValue(), readable);
                            SNAPSHOT.addElement(snapshot, sb, entry.getKey(), readable);
                            sb.append("PUT");
                            sb.append(" ");
                        }
                    }
                    break block51;
                }
                if (o instanceof BitSet) {
                    sb.append("'");
                    sb.append(new String(OrderPreservingBase64.encode(((BitSet)o).toByteArray()), StandardCharsets.UTF_8));
                    sb.append("' ");
                    sb.append("OPB64->");
                    sb.append(" ");
                    sb.append("BYTESTOBITS");
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof byte[]) {
                    sb.append("'");
                    sb.append(new String(OrderPreservingBase64.encode((byte[])o), StandardCharsets.UTF_8));
                    sb.append("' ");
                    sb.append("OPB64->");
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof GeoXPLib.GeoXPShape) {
                    sb.append("'");
                    sb.append(GEOPACK.pack((GeoXPLib.GeoXPShape)o));
                    sb.append("' ");
                    sb.append("GEOUNPACK");
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof WarpScriptStack.Mark) {
                    sb.append("MARK");
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof Snapshotable) {
                    sb.append(((Snapshotable)o).snapshot());
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof WarpScriptStack.Macro) {
                    sb.append(o.toString());
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof RSAPublicKey) {
                    sb.append("{ 'algorithm' 'RSA' 'exponent' '");
                    sb.append(((RSAPublicKey)o).getPublicExponent());
                    sb.append("' 'modulus' '");
                    sb.append(((RSAPublicKey)o).getModulus());
                    sb.append("' } ");
                    sb.append("RSAPUBLIC");
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof RSAPrivateKey) {
                    sb.append("{ 'algorithm' 'RSA' 'exponent' '");
                    sb.append(((RSAPrivateKey)o).getPrivateExponent());
                    sb.append("' 'modulus' '");
                    sb.append(((RSAPrivateKey)o).getModulus());
                    sb.append("' } ");
                    sb.append("RSAPRIVATE");
                    sb.append(" ");
                    break block51;
                }
                if (o instanceof NamedWarpScriptFunction) {
                    sb.append(o.toString());
                    sb.append(" ");
                    break block51;
                }
                try {
                    sb.append("'UNSUPPORTED:" + WarpURLEncoder.encode(o.getClass().toString(), StandardCharsets.UTF_8) + "' ");
                }
                catch (UnsupportedEncodingException uee) {
                    throw new WarpScriptException(uee);
                }
            }
            finally {
                if (null != depth && 0 == depth.addAndGet(-1)) {
                    recursionDepth.remove();
                }
            }
        }
    }

    private static void appendProcessedString(StringBuilder sb, String s) {
        char[] chars = UnsafeString.getChars(s);
        int lastIdx = 0;
        int idx = 0;
        while (idx < chars.length) {
            if ('\'' == chars[idx] || chars[idx] < ' ') {
                sb.append(chars, lastIdx, idx - lastIdx);
                sb.append("%" + (chars[idx] >>> 4) + Integer.toHexString(chars[idx] & 0xF));
                lastIdx = ++idx;
                continue;
            }
            ++idx;
        }
        if (idx > lastIdx) {
            sb.append(chars, lastIdx, idx - lastIdx);
        }
    }

    public static interface Snapshotable {
        public String snapshot();
    }
}

