/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SORTBY
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SORTBY(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects a macro on top of the stack.");
        }
        WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " operates on a list.");
        }
        String type = null;
        Object[] values = null;
        int idx = 0;
        for (Object elt : (List)top) {
            stack.push(elt);
            stack.exec(macro);
            Object value = stack.pop();
            String valtype = null;
            if (value instanceof Long) {
                valtype = "LONG";
            } else if (value instanceof Double) {
                valtype = "DOUBLE";
            } else if (value instanceof String) {
                valtype = "STRING";
            }
            if (null == value || null == valtype || null != type && !type.equals(valtype)) {
                throw new WarpScriptException(this.getName() + " expects its macro to return a non null double,long or string in a consistent manner.");
            }
            if (null == type) {
                switch (valtype) {
                    case "LONG": {
                        values = new long[((List)top).size()];
                        break;
                    }
                    case "DOUBLE": {
                        values = new double[((List)top).size()];
                        break;
                    }
                    case "STRING": {
                        values = new String[((List)top).size()];
                    }
                }
                type = valtype;
            }
            switch (type) {
                case "LONG": {
                    ((long[])values)[idx] = ((Number)value).longValue();
                    break;
                }
                case "DOUBLE": {
                    ((double[])values)[idx] = ((Number)value).doubleValue();
                    break;
                }
                case "STRING": {
                    ((String[])values)[idx] = value.toString();
                }
            }
            ++idx;
        }
        String valtype = type;
        Comparator<Integer> comparator = null;
        if ("LONG".equals(valtype)) {
            final long[] lvalues = values;
            comparator = new Comparator<Integer>(){

                @Override
                public int compare(Integer i1, Integer i2) {
                    if (lvalues[i1] < lvalues[i2]) {
                        return -1;
                    }
                    if (lvalues[i1] > lvalues[i2]) {
                        return 1;
                    }
                    return 0;
                }
            };
        } else if ("DOUBLE".equals(valtype)) {
            final double[] dvalues = values;
            comparator = new Comparator<Integer>(){

                @Override
                public int compare(Integer i1, Integer i2) {
                    if (dvalues[i1] < dvalues[i2]) {
                        return -1;
                    }
                    if (dvalues[i1] > dvalues[i2]) {
                        return 1;
                    }
                    return 0;
                }
            };
        } else if ("STRING".equals(valtype)) {
            final String[] svalues = (String[])values;
            comparator = new Comparator<Integer>(){

                @Override
                public int compare(Integer i1, Integer i2) {
                    return svalues[i1].compareTo(svalues[i2]);
                }
            };
        }
        ArrayList<Integer> indices = new ArrayList<Integer>(idx);
        for (int i = 0; i < idx; ++i) {
            indices.add(i);
        }
        Collections.sort(indices, comparator);
        Object[] target = new Object[indices.size()];
        for (int i = 0; i < target.length; ++i) {
            target[i] = ((List)top).get((Integer)indices.get(i));
        }
        ((List)top).clear();
        for (Object elt : target) {
            ((List)top).add(elt);
        }
        stack.push(top);
        return stack;
    }
}

