/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpConfig;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TIMEBOX
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final long DEFAULT_TIMEBOX_MAXTIME = 30000L;
    private static final long TIMEBOX_MAXTIME = Long.parseLong(WarpConfig.getProperty("warpscript.timebox.maxtime", Long.toString(30000L)));

    public TIMEBOX(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a maximum execution time on top of the stack.");
        }
        long maxtime = Math.min(Math.max(0L, ((Number)top).longValue() / Constants.TIME_UNITS_PER_MS), TIMEBOX_MAXTIME);
        top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a macro.");
        }
        final WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        final WarpScriptStack fstack = stack;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Object> future = executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                fstack.exec(macro);
                return fstack;
            }
        });
        try {
            future.get(maxtime, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new WarpScriptException(this.getName() + " reached the execution time limit (" + maxtime + " ms).");
        }
        catch (ExecutionException ee) {
            throw new WarpScriptException(this.getName() + " encountered an exception while executing macro", ee.getCause());
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " encountered an exception", e);
        }
        finally {
            executorService.shutdown();
            executorService.shutdownNow();
            if (!executorService.isShutdown()) {
                throw new WarpScriptException(this.getName() + " could not be properly shut down.");
            }
        }
        return stack;
    }
}

