/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.unary.TOTIMESTAMP;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TIMECLIP
extends ElementOrListStackFunction {
    private DateTimeFormatter fmt = ISODateTimeFormat.dateTimeParser();

    public TIMECLIP(String name) {
        super(name);
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        long end;
        long start;
        Object top = stack.pop();
        boolean iso8601 = false;
        if (top instanceof String) {
            iso8601 = true;
            start = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8) ? TOTIMESTAMP.parseTimestamp(top.toString()) : this.fmt.parseDateTime(top.toString()).getMillis() * Constants.TIME_UNITS_PER_MS;
        } else {
            if (!(top instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects either an ISO8601 timestamp as the origin timestamp or a duration.");
            }
            start = (Long)top;
        }
        top = stack.pop();
        if (top instanceof String) {
            end = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8) ? TOTIMESTAMP.parseTimestamp(top.toString()) : this.fmt.parseDateTime(top.toString()).getMillis() * Constants.TIME_UNITS_PER_MS;
        } else {
            if (!(top instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects either an ISO8601 timestamp or a delta since Unix Epoch as 'now' parameter.");
            }
            end = (Long)top;
        }
        if (!iso8601) {
            start = end - start + 1L;
        }
        final long finalStart = start;
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                if (element instanceof GeoTimeSerie) {
                    return GTSHelper.timeclip((GeoTimeSerie)element, finalStart, end);
                }
                if (element instanceof GTSEncoder) {
                    return GTSHelper.timeclip((GTSEncoder)element, finalStart, end);
                }
                throw new WarpScriptException(TIMECLIP.this.getName() + " expects a Geo Time Series, a GTSEncoder or a list thereof under the timeframe definition.");
            }
        };
    }
}

