/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.nio.charset.StandardCharsets;

public class TOBIN
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String[] NIBBLES = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};

    public TOBIN(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        byte[] data = null;
        if (o instanceof String) {
            data = o.toString().getBytes(StandardCharsets.UTF_8);
        } else if (o instanceof byte[]) {
            data = (byte[])o;
        }
        if (null == data) {
            throw new WarpScriptException(this.getName() + " operates on a String or a byte array.");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int nibble = data[i] >>> 4 & 0xF;
            sb.append(NIBBLES[nibble]);
            nibble = data[i] & 0xF;
            sb.append(NIBBLES[nibble]);
        }
        stack.push(sb.toString());
        return stack;
    }
}

