/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class TOGTS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOGTS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        GTSDecoder decoder;
        Object top = stack.pop();
        if (!(top instanceof String || top instanceof byte[] || top instanceof GTSEncoder)) {
            throw new WarpScriptException(this.getName() + " operates on a string, byte array or encoder.");
        }
        HashMap<String, GeoTimeSerie> series = new HashMap<String, GeoTimeSerie>();
        if (top instanceof GTSEncoder) {
            decoder = ((GTSEncoder)top).getUnsafeDecoder(false);
        } else {
            try {
                byte[] bytes = top instanceof String ? OrderPreservingBase64.decode(top.toString().getBytes(StandardCharsets.US_ASCII)) : (byte[])top;
                TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
                GTSWrapper wrapper = new GTSWrapper();
                deser.deserialize((TBase)wrapper, bytes);
                decoder = GTSWrapperHelper.fromGTSWrapperToGTSDecoder(wrapper);
            }
            catch (TException te) {
                throw new WarpScriptException(this.getName() + " failed to unwrap encoder.", te);
            }
        }
        while (decoder.next()) {
            Object value = decoder.getBinaryValue();
            String type = "DOUBLE";
            if (value instanceof String) {
                type = "STRING";
            } else if (value instanceof Boolean) {
                type = "BOOLEAN";
            } else if (value instanceof Long) {
                type = "LONG";
            } else if (value instanceof Double || value instanceof BigDecimal) {
                type = "DOUBLE";
            } else if (value instanceof byte[]) {
                type = "BINARY";
            }
            GeoTimeSerie gts = (GeoTimeSerie)series.get(type);
            if (null == gts) {
                gts = new GeoTimeSerie();
                gts.setMetadata(decoder.getMetadata());
                series.put(type, gts);
            }
            GTSHelper.setValue(gts, decoder.getTimestamp(), decoder.getLocation(), decoder.getElevation(), value, false);
        }
        stack.push(series);
        return stack;
    }
}

