/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.ThrottlingManager;
import io.warp10.continuum.Tokens;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.quasar.token.thrift.data.WriteToken;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.HashMap;
import java.util.Map;

public class TOKENINFO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOKENINFO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a string on top of the stack.");
        }
        HashMap<String, Object> tokenParams = new HashMap<String, Object>();
        String readError = null;
        String writeError = null;
        try {
            ReadToken rtoken = Tokens.extractReadToken(o.toString());
            tokenParams.put("type", "READ");
            tokenParams.put("issuance", rtoken.getIssuanceTimestamp());
            tokenParams.put("expiry", rtoken.getExpiryTimestamp());
            tokenParams.put("application", rtoken.getAppName());
            if (rtoken.getAppsSize() > 0) {
                tokenParams.put("apps", rtoken.getApps());
            }
            if (rtoken.getLabelsSize() > 0) {
                tokenParams.put("labels", rtoken.getLabels());
            }
        }
        catch (WarpScriptException ee) {
            readError = ee.getMessage();
        }
        try {
            WriteToken wtoken = Tokens.extractWriteToken(o.toString());
            tokenParams.put("type", "WRITE");
            tokenParams.put("issuance", wtoken.getIssuanceTimestamp());
            tokenParams.put("expiry", wtoken.getExpiryTimestamp());
            tokenParams.put("application", wtoken.getAppName());
            if (wtoken.getLabelsSize() > 0) {
                tokenParams.put("labels", wtoken.getLabels());
            }
            Map limits = ThrottlingManager.getLimits((String)Tokens.getUUID(wtoken.getProducerId()), (String)wtoken.getAppName());
            tokenParams.put("limits", limits);
        }
        catch (WarpScriptException ee) {
            writeError = ee.getMessage();
        }
        if (null != readError && null != writeError) {
            tokenParams.put("ReadTokenDecodeError", readError);
            tokenParams.put("WriteTokenDecodeError", writeError);
        }
        stack.push(tokenParams);
        return stack;
    }
}

