/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class UNWRAPENCODER
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public UNWRAPENCODER(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String) && !(top instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a string or byte array.");
        }
        byte[] bytes = top instanceof String ? OrderPreservingBase64.decode(top.toString().getBytes(StandardCharsets.US_ASCII)) : (byte[])top;
        TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
        try {
            GTSWrapper wrapper = new GTSWrapper();
            deser.deserialize((TBase)wrapper, bytes);
            stack.push(GTSWrapperHelper.fromGTSWrapperToGTSEncoder(wrapper));
        }
        catch (TException te) {
            throw new WarpScriptException(this.getName() + " failed to unwrap encoder.", te);
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " failed to unwrap encoder.", ioe);
        }
        return stack;
    }
}

