/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.CSTORE;
import io.warp10.script.functions.LOAD;
import io.warp10.script.functions.STORE;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicInteger;

public class VARS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public VARS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a macro.");
        }
        LinkedHashSet<String> symbols = new LinkedHashSet<String>();
        final HashMap<String, AtomicInteger> occurrences = new HashMap<String, AtomicInteger>();
        ArrayList<WarpScriptStack.Macro> allmacros = new ArrayList<WarpScriptStack.Macro>();
        allmacros.add((WarpScriptStack.Macro)top);
        boolean abort = false;
        block0: while (!abort && !allmacros.isEmpty()) {
            WarpScriptStack.Macro m = (WarpScriptStack.Macro)allmacros.remove(0);
            ArrayList<Object> statements = new ArrayList<Object>(m.statements());
            for (int i = 0; i < statements.size(); ++i) {
                if (statements.get(i) instanceof WarpScriptStack.Macro) {
                    allmacros.add((WarpScriptStack.Macro)statements.get(i));
                    continue;
                }
                if (!(statements.get(i) instanceof LOAD) && !(statements.get(i) instanceof STORE) && !(statements.get(i) instanceof CSTORE)) continue;
                Object symbol = statements.get(i - 1);
                if (!(symbol instanceof String)) {
                    abort = true;
                    continue block0;
                }
                symbols.add(symbol.toString());
                AtomicInteger occ = (AtomicInteger)occurrences.get(symbol.toString());
                if (null == occ) {
                    occ = new AtomicInteger();
                    occurrences.put(symbol.toString(), occ);
                }
                occ.incrementAndGet();
            }
        }
        if (abort) {
            throw new WarpScriptException(this.getName() + " encountered a LOAD/STORE or CSTORE operation with a non explicit symbol name.");
        }
        ArrayList<String> vars = new ArrayList<String>(symbols);
        vars.sort(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                AtomicInteger occ1 = (AtomicInteger)occurrences.get(s1);
                AtomicInteger occ2 = (AtomicInteger)occurrences.get(s2);
                if (occ1.get() < occ2.get()) {
                    return 1;
                }
                if (occ1.get() > occ2.get()) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
        });
        stack.push(vars);
        return stack;
    }
}

