/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLoopBreakException;
import io.warp10.script.WarpScriptLoopContinueException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class WHILE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final long maxtime;

    public WHILE(String name) {
        super(name);
        this.maxtime = -1L;
    }

    public WHILE(String name, long maxtime) {
        super(name);
        this.maxtime = maxtime;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long maxtime;
        Object[] macros = new Object[]{stack.pop(), stack.pop()};
        for (Object macro : macros) {
            if (macro instanceof WarpScriptStack.Macro) continue;
            throw new WarpScriptException(this.getName() + " expects two macros on top of the stack.");
        }
        long now = System.currentTimeMillis();
        long l = maxtime = this.maxtime > 0L ? this.maxtime : (Long)stack.getAttribute("loop.maxduration");
        while (true) {
            if (maxtime > 0L && System.currentTimeMillis() - now > maxtime) {
                throw new WarpScriptException(this.getName() + " executed for too long (> " + maxtime + " ms).");
            }
            stack.exec((WarpScriptStack.Macro)macros[1]);
            Object top = stack.pop();
            if (!(top instanceof Boolean)) {
                throw new WarpScriptException(this.getName() + " expects its 'WHILE' macro to leave a boolean on top of the stack.");
            }
            if (!Boolean.TRUE.equals(top)) break;
            try {
                stack.exec((WarpScriptStack.Macro)macros[0]);
                continue;
            }
            catch (WarpScriptLoopBreakException elbe) {
            }
            catch (WarpScriptLoopContinueException warpScriptLoopContinueException) {
                continue;
            }
            break;
        }
        return stack;
    }
}

