/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSOutliersHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.Map;

public class ZSCORETEST
extends GTSStackFunction {
    private static final String MODIFIED_PARAM = "mad";
    private static final String THRESHOLD_PARAM = "t";
    private static final double THRESHOLD_DEFAULT = 3.5;

    public ZSCORETEST(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object top = stack.pop();
        boolean t_is_default = false;
        if (!(top instanceof Double)) {
            if (!(top instanceof Boolean)) {
                throw new WarpScriptException(this.getName() + " expects a threshold level (a DOUBLE) or a flag (a BOOLEAN) on top of the stack.");
            }
            t_is_default = true;
        }
        if (!t_is_default) {
            params.put(THRESHOLD_PARAM, (Double)top);
            top = stack.pop();
        } else {
            params.put(THRESHOLD_PARAM, 3.5);
        }
        if (!(top instanceof Boolean)) {
            throw new WarpScriptException(this.getName() + " expects a flag (a BOOLEAN) that indicates wether to use modified z-score below the THRESHOLD level.");
        }
        params.put(MODIFIED_PARAM, (Boolean)top);
        return params;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        boolean mad = (Boolean)params.get(MODIFIED_PARAM);
        double t = (Double)params.get(THRESHOLD_PARAM);
        return GTSOutliersHelper.zScoreTest(gts, mad, t);
    }
}

