/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;

public class ZTO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public ZTO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a bit width on top of the stack.");
        }
        int bitwidth = ((Long)o).intValue();
        if (bitwidth > 63 || bitwidth < 0) {
            throw new WarpScriptException(this.getName() + " expects a bit width <= 63.");
        }
        o = stack.pop();
        if (!(o instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a number of components below the bit width.");
        }
        int nlongs = ((Long)o).intValue();
        o = stack.pop();
        if (!(o instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a Morton code encoded as a byte array.");
        }
        byte[] encoded = (byte[])o;
        long[] longs = new long[nlongs];
        int byteidx = 0;
        int bitcount = 0;
        long value = 0L;
        for (int i = 0; i < bitwidth; ++i) {
            for (int j = 0; j < longs.length; ++j) {
                if (0 == bitcount) {
                    value = (long)encoded[byteidx++] & 0xFFL;
                    bitcount = 8;
                    value = (value * 0x202020202L & 0x10884422010L) % 1023L;
                }
                longs[j] = longs[j] << 1 | value & 1L;
                value >>>= 1;
                --bitcount;
            }
        }
        ArrayList<Long> l = new ArrayList<Long>(longs.length);
        for (long lo : longs) {
            l.add(lo);
        }
        stack.push(l);
        return stack;
    }
}

