/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.processing.color;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.processing.ProcessingUtil;
import java.util.List;
import processing.core.PGraphics;

public class PcolorMode
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public PcolorMode(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        int mode;
        List<Object> params = ProcessingUtil.parseParams(stack, 1, 2, 4, 5);
        PGraphics pg = (PGraphics)params.get(0);
        String modestr = params.get(1).toString();
        if (!"RGB".equals(modestr) && !"HSB".equals(modestr)) {
            throw new WarpScriptException(this.getName() + ": invalid mode, should be one of 'RGB' or 'HSB'");
        }
        int n = mode = "RGB".equals(modestr) ? 1 : 3;
        if (2 == params.size()) {
            pg.colorMode(mode);
        } else if (3 == params.size()) {
            pg.colorMode(mode, ((Number)params.get(2)).floatValue());
        } else if (5 == params.size()) {
            pg.colorMode(mode, ((Number)params.get(2)).floatValue(), ((Number)params.get(3)).floatValue(), ((Number)params.get(4)).floatValue());
        } else if (6 == params.size()) {
            pg.colorMode(mode, ((Number)params.get(2)).floatValue(), ((Number)params.get(3)).floatValue(), ((Number)params.get(4)).floatValue(), ((Number)params.get(5)).floatValue());
        }
        stack.push(pg);
        return stack;
    }
}

