/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision;

import io.warp10.sensision.Sensision;
import io.warp10.sensision.jarjar.javax.servlet.ServletException;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletRequest;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletResponse;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.AbstractConnector;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.Connector;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.Request;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.Server;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.bio.SocketConnector;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.handler.AbstractHandler;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.nio.SelectChannelConnector;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.thread.QueuedThreadPool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class SensisionMetricsServer
extends Thread {
    private int port;
    public static final String SENSISION_SERVER_CONNECTOR = "sensision.server.connector";
    public static final String SENSISION_SERVER_BINDALL = "sensision.server.bindall";
    public static final String SENSISION_SERVER_LASTEVENT_PARAM = "lastevent";
    public static final String SENSISION_SERVER_EVENTS_PARAM = "events";
    public static final String SENSISION_SERVER_PEEK_PARAM = "peek";

    public SensisionMetricsServer() {
        if (Sensision.disable) {
            return;
        }
        try {
            this.port = Integer.valueOf(System.getProperty("sensision.server.port", "0"));
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Unable to parse server port " + System.getProperty("sensision.server.port"));
        }
        this.setDaemon(true);
        this.setName("[Sensision MetricsServer]");
        this.start();
    }

    public void run() {
        AbstractConnector connector;
        Server server = new Server();
        QueuedThreadPool pool = new QueuedThreadPool();
        pool.setDaemon(true);
        server.setThreadPool(pool);
        server.setStopAtShutdown(true);
        String conn = System.getProperty(SENSISION_SERVER_CONNECTOR, "nio");
        boolean bindall = "true".equals(System.getProperty(SENSISION_SERVER_BINDALL));
        if ("bio".equals(conn)) {
            connector = new SocketConnector();
            if (bindall) {
                connector.setHost(null);
            } else {
                connector.setHost("127.0.0.1");
            }
            connector.setPort(this.port);
            connector.setAcceptors(1);
            server.setConnectors(new Connector[]{connector});
        } else {
            connector = new SelectChannelConnector();
            if (bindall) {
                connector.setHost(null);
            } else {
                connector.setHost("127.0.0.1");
            }
            connector.setPort(this.port);
            connector.setAcceptors(1);
            server.setConnectors(new Connector[]{connector});
        }
        server.setHandler(new MetricsHandler(this));
        try {
            server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.port = server.getConnectors()[0].getLocalPort();
        this.setName("[Sensision MetricsServer (" + this.port + ")]");
        while (!server.isStopping()) {
            try {
                this.register();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {}
        }
        try {
            server.join();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private void register() {
        File targetDir = Sensision.getTargetsDir();
        String filename = Long.toHexString(Long.MAX_VALUE - Sensision.getStartTime());
        filename = filename + "." + System.getProperty("sensision.polling.hint", "60000");
        filename = filename + ".";
        filename = filename + Sensision.getUUID();
        filename = filename + ".";
        filename = filename + this.port;
        if (null != Sensision.getInstance()) {
            filename = filename + "." + Sensision.getInstance();
        }
        filename = filename + ".target";
        File reg = new File(targetDir, filename);
        reg.deleteOnExit();
        if (reg.exists()) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(reg);
            ((Writer)writer).append("");
            ((Writer)writer).close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void dumpMetrics(PrintWriter out, boolean useValueTimestamp) throws IOException {
        Sensision.dump(out, useValueTimestamp);
    }

    public void dumpEvents(HttpServletResponse response, long lastevent, int n) throws IOException {
        List<String> events = Sensision.getEvents();
        long curevent = Sensision.getCurrentEvent();
        if (0 == events.size() || -1L == curevent || n <= 0) {
            return;
        }
        lastevent = lastevent >= 0L ? Math.max(Math.max(lastevent, curevent - (long)events.size()), -1L) : Math.max(curevent - (long)events.size(), -1L);
        if (n > events.size()) {
            n = events.size();
        }
        response.setHeader("X-Sensision-LastEvent", Long.toString(Math.min(curevent, lastevent + (long)events.size())));
        PrintWriter out = response.getWriter();
        while (n > 0 && lastevent < Sensision.getCurrentEvent()) {
            ++lastevent;
            lastevent = Math.max(Sensision.getCurrentEvent() - (long)events.size() + 1L, lastevent);
            int idx = (int)(lastevent % (long)events.size());
            out.println(events.get(idx));
            --n;
        }
    }

    private static final class MetricsHandler
    extends AbstractHandler {
        private final SensisionMetricsServer server;

        public MetricsHandler(SensisionMetricsServer server) {
            this.server = server;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("/metrics".equals(target)) {
                String valuets = request.getParameter("valuets");
                response.setContentType("text/plain;charset=utf-8");
                if (null != System.getProperty("sensision.http.nokeepalive")) {
                    response.setHeader("Connection", "close");
                }
                response.setHeader("X-UUID", Sensision.getUUID());
                response.setHeader("X-Timestamp", Long.toHexString(Long.MAX_VALUE - Sensision.getStartTime()));
                response.setStatus(200);
                baseRequest.setHandled(true);
                PrintWriter out = response.getWriter();
                this.server.dumpMetrics(out, null != valuets);
            } else if ("/events".equals(target)) {
                boolean peek;
                boolean onDisk = Sensision.onDisk();
                boolean bl = peek = null != request.getParameter(SensisionMetricsServer.SENSISION_SERVER_PEEK_PARAM);
                if (!onDisk || onDisk && peek) {
                    long lastevent = -1L;
                    int nevents = Integer.MAX_VALUE;
                    if (null != request.getParameter(SensisionMetricsServer.SENSISION_SERVER_LASTEVENT_PARAM)) {
                        lastevent = Long.parseLong(request.getParameter(SensisionMetricsServer.SENSISION_SERVER_LASTEVENT_PARAM));
                    }
                    if (null != request.getParameter(SensisionMetricsServer.SENSISION_SERVER_EVENTS_PARAM)) {
                        nevents = Integer.parseInt(request.getParameter(SensisionMetricsServer.SENSISION_SERVER_EVENTS_PARAM));
                    }
                    response.setContentType("text/plain;charset=utf-8");
                    if (null != System.getProperty("sensision.http.nokeepalive")) {
                        response.setHeader("Connection", "close");
                    }
                    response.setHeader("X-UUID", Sensision.getUUID());
                    response.setHeader("X-Timestamp", Long.toHexString(Long.MAX_VALUE - Sensision.getStartTime()));
                    response.setStatus(200);
                    baseRequest.setHandled(true);
                    this.server.dumpEvents(response, lastevent, nevents);
                } else {
                    baseRequest.setHandled(true);
                    Sensision.flushEvents();
                }
            } else {
                baseRequest.setHandled(false);
                return;
            }
        }
    }
}

