/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.hadoop;

import io.warp10.sensision.Sensision;
import io.warp10.sensision.hadoop.SensisionSink;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.metrics.spi.AbstractMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;

public class SensisionContext
extends AbstractMetricsContext {
    private static final Pattern RSDS_TBL_CF = Pattern.compile("^(tbl\\.(.*?)\\.)?(region\\.(.*?)\\.)?(cf\\.(.*?)\\.)?(bt\\.(.*?)\\.)?(at\\.(.*?)\\.)?([^.]+)$");
    private Long ttl = null;

    public SensisionContext() {
        if (null != System.getProperty(SensisionSink.HADOOP_SENSISION_TTL)) {
            this.ttl = Long.parseLong(System.getProperty(SensisionSink.HADOOP_SENSISION_TTL));
        }
    }

    protected void emitRecord(String context, String recordName, OutputRecord outputRec) throws IOException {
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String tagName : outputRec.getTagNames()) {
            labels.put(tagName, outputRec.getTag(tagName).toString());
        }
        labels.put("context", context);
        for (String metricName : outputRec.getMetricNames()) {
            String cls;
            if (recordName.startsWith("RegionServerDynamicStatistics")) {
                Matcher m = RSDS_TBL_CF.matcher(metricName);
                if (m.matches()) {
                    if (null != m.group(1)) {
                        labels.put("tbl", m.group(2));
                    }
                    if (null != m.group(3)) {
                        labels.put("region", m.group(4));
                    }
                    if (null != m.group(5)) {
                        labels.put("cf", m.group(6));
                    }
                    if (null != m.group(7)) {
                        labels.put("bt", m.group(8));
                    }
                    if (null != m.group(9)) {
                        labels.put("at", m.group(10));
                    }
                    cls = "" + recordName + "." + m.group(11);
                    Sensision.set(cls, labels, outputRec.getMetric(metricName));
                    labels.remove("tbl");
                    labels.remove("region");
                    labels.remove("cf");
                    labels.remove("bt");
                    labels.remove("at");
                    continue;
                }
                cls = "" + recordName + "." + metricName;
                Sensision.set(cls, labels, System.currentTimeMillis() * Sensision.TIME_UNITS_PER_MS, null, null, null, outputRec.getMetric(metricName), this.ttl);
                continue;
            }
            cls = "" + recordName + "." + metricName;
            Sensision.set(cls, labels, System.currentTimeMillis() * Sensision.TIME_UNITS_PER_MS, null, null, null, outputRec.getMetric(metricName), this.ttl);
        }
    }
}

