/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.eclipse.jetty.http;

import io.warp10.sensision.jarjar.org.eclipse.jetty.util.MultiMap;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.StringUtil;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.TypeUtil;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.URIUtil;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.UrlEncoded;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.Utf8StringBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URI;

public class HttpURI {
    private static final byte[] __empty = new byte[0];
    private static final int START = 0;
    private static final int AUTH_OR_PATH = 1;
    private static final int SCHEME_OR_PATH = 2;
    private static final int AUTH = 4;
    private static final int IPV6 = 5;
    private static final int PORT = 6;
    private static final int PATH = 7;
    private static final int PARAM = 8;
    private static final int QUERY = 9;
    private static final int ASTERISK = 10;
    boolean _partial = false;
    byte[] _raw = __empty;
    String _rawString;
    int _scheme;
    int _authority;
    int _host;
    int _port;
    int _portValue;
    int _path;
    int _param;
    int _query;
    int _fragment;
    int _end;
    boolean _encoded = false;
    final Utf8StringBuilder _utf8b = new Utf8StringBuilder(64);

    public HttpURI() {
    }

    public HttpURI(boolean parsePartialAuth) {
        this._partial = parsePartialAuth;
    }

    public HttpURI(String raw) {
        byte[] b;
        this._rawString = raw;
        try {
            b = raw.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.parse(b, 0, b.length);
    }

    public HttpURI(byte[] raw, int offset, int length) {
        this.parse2(raw, offset, length);
    }

    public HttpURI(URI uri) {
        this.parse(uri.toASCIIString());
    }

    public void parse(String raw) {
        byte[] b = raw.getBytes();
        this.parse2(b, 0, b.length);
        this._rawString = raw;
    }

    public void parse(byte[] raw, int offset, int length) {
        this._rawString = null;
        this.parse2(raw, offset, length);
    }

    public void parseConnect(byte[] raw, int offset, int length) {
        this._rawString = null;
        this._encoded = false;
        this._raw = raw;
        int i = offset;
        int e = offset + length;
        int state = 4;
        this._end = offset + length;
        this._scheme = offset;
        this._authority = offset;
        this._host = offset;
        this._port = this._end;
        this._portValue = -1;
        this._path = this._end;
        this._param = this._end;
        this._query = this._end;
        this._fragment = this._end;
        block12: while (i < e) {
            char c = (char)(0xFF & this._raw[i]);
            int s = i++;
            switch (state) {
                case 4: {
                    switch (c) {
                        case ':': {
                            this._port = s;
                            break block12;
                        }
                        case '[': {
                            state = 5;
                        }
                    }
                    continue block12;
                }
                case 5: {
                    switch (c) {
                        case '/': {
                            throw new IllegalArgumentException("No closing ']' for " + StringUtil.toString(this._raw, offset, length, URIUtil.__CHARSET));
                        }
                        case ']': {
                            state = 4;
                        }
                    }
                    continue block12;
                }
                default: {
                    continue block12;
                }
            }
        }
        if (this._port >= this._path) {
            throw new IllegalArgumentException("No port");
        }
        this._portValue = TypeUtil.parseInt(this._raw, this._port + 1, this._path - this._port - 1, 10);
        this._path = offset;
    }

    private void parse2(byte[] raw, int offset, int length) {
        this._encoded = false;
        this._raw = raw;
        int i = offset;
        int e = offset + length;
        int state = 0;
        int m = offset;
        this._end = offset + length;
        this._scheme = offset;
        this._authority = offset;
        this._host = offset;
        this._port = offset;
        this._portValue = -1;
        this._path = offset;
        this._param = this._end;
        this._query = this._end;
        this._fragment = this._end;
        while (i < e) {
            int c = 0xFF & this._raw[i];
            int s = i++;
            switch (state) {
                case 0: {
                    m = s;
                    switch (c) {
                        case 47: {
                            state = 1;
                            break;
                        }
                        case 59: {
                            this._param = s;
                            state = 8;
                            break;
                        }
                        case 63: {
                            this._param = s;
                            this._query = s;
                            state = 9;
                            break;
                        }
                        case 35: {
                            this._param = s;
                            this._query = s;
                            this._fragment = s;
                            break;
                        }
                        case 42: {
                            this._path = s;
                            state = 10;
                            break;
                        }
                        default: {
                            state = 2;
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    if ((this._partial || this._scheme != this._authority) && c == 47) {
                        this._host = i;
                        this._port = this._end;
                        this._path = this._end;
                        state = 4;
                        break;
                    }
                    if (c == 59 || c == 63 || c == 35) {
                        --i;
                        state = 7;
                        break;
                    }
                    this._host = m;
                    this._port = m;
                    state = 7;
                    break;
                }
                case 2: {
                    if (length > 6 && c == 116) {
                        if (this._raw[offset + 3] == 58) {
                            s = offset + 3;
                            i = offset + 4;
                            c = 58;
                        } else if (this._raw[offset + 4] == 58) {
                            s = offset + 4;
                            i = offset + 5;
                            c = 58;
                        } else if (this._raw[offset + 5] == 58) {
                            s = offset + 5;
                            i = offset + 6;
                            c = 58;
                        }
                    }
                    switch (c) {
                        case 58: {
                            this._authority = m = i++;
                            this._path = m;
                            c = (char)(0xFF & this._raw[i]);
                            if (c == 47) {
                                state = 1;
                                break;
                            }
                            this._host = m;
                            this._port = m;
                            state = 7;
                            break;
                        }
                        case 47: {
                            state = 7;
                            break;
                        }
                        case 59: {
                            this._param = s;
                            state = 8;
                            break;
                        }
                        case 63: {
                            this._param = s;
                            this._query = s;
                            state = 9;
                            break;
                        }
                        case 35: {
                            this._param = s;
                            this._query = s;
                            this._fragment = s;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (c) {
                        case 47: {
                            this._port = this._path = (m = s);
                            state = 7;
                            break;
                        }
                        case 64: {
                            this._host = i;
                            break;
                        }
                        case 58: {
                            this._port = s;
                            state = 6;
                            break;
                        }
                        case 91: {
                            state = 5;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (c) {
                        case 47: {
                            throw new IllegalArgumentException("No closing ']' for " + StringUtil.toString(this._raw, offset, length, URIUtil.__CHARSET));
                        }
                        case 93: {
                            state = 4;
                        }
                    }
                    break;
                }
                case 6: {
                    if (c != 47) break;
                    this._path = m = s;
                    if (this._port <= this._authority) {
                        this._port = this._path;
                    }
                    state = 7;
                    break;
                }
                case 7: {
                    switch (c) {
                        case 59: {
                            this._param = s;
                            state = 8;
                            break;
                        }
                        case 63: {
                            this._param = s;
                            this._query = s;
                            state = 9;
                            break;
                        }
                        case 35: {
                            this._param = s;
                            this._query = s;
                            this._fragment = s;
                            break;
                        }
                        case 37: {
                            this._encoded = true;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (c) {
                        case 63: {
                            this._query = s;
                            state = 9;
                            break;
                        }
                        case 35: {
                            this._query = s;
                            this._fragment = s;
                            break;
                        }
                    }
                    break;
                }
                case 9: {
                    if (c != 35) break;
                    this._fragment = s;
                    break;
                }
                case 10: {
                    throw new IllegalArgumentException("only '*'");
                }
            }
        }
        if (this._port < this._path) {
            this._portValue = TypeUtil.parseInt(this._raw, this._port + 1, this._path - this._port - 1, 10);
        }
    }

    private String toUtf8String(int offset, int length) {
        this._utf8b.reset();
        this._utf8b.append(this._raw, offset, length);
        return this._utf8b.toString();
    }

    public String getScheme() {
        if (this._scheme == this._authority) {
            return null;
        }
        int l = this._authority - this._scheme;
        if (l == 5 && this._raw[this._scheme] == 104 && this._raw[this._scheme + 1] == 116 && this._raw[this._scheme + 2] == 116 && this._raw[this._scheme + 3] == 112) {
            return "http";
        }
        if (l == 6 && this._raw[this._scheme] == 104 && this._raw[this._scheme + 1] == 116 && this._raw[this._scheme + 2] == 116 && this._raw[this._scheme + 3] == 112 && this._raw[this._scheme + 4] == 115) {
            return "https";
        }
        return this.toUtf8String(this._scheme, this._authority - this._scheme - 1);
    }

    public String getAuthority() {
        if (this._authority == this._path) {
            return null;
        }
        return this.toUtf8String(this._authority, this._path - this._authority);
    }

    public String getHost() {
        if (this._host == this._port) {
            return null;
        }
        return this.toUtf8String(this._host, this._port - this._host);
    }

    public int getPort() {
        return this._portValue;
    }

    public String getPath() {
        if (this._path == this._param) {
            return null;
        }
        return this.toUtf8String(this._path, this._param - this._path);
    }

    public String getDecodedPath() {
        if (this._path == this._param) {
            return null;
        }
        int length = this._param - this._path;
        boolean decoding = false;
        for (int i = this._path; i < this._param; ++i) {
            byte b = this._raw[i];
            if (b == 37) {
                if (!decoding) {
                    this._utf8b.reset();
                    this._utf8b.append(this._raw, this._path, i - this._path);
                    decoding = true;
                }
                if (i + 2 >= this._param) {
                    throw new IllegalArgumentException("Bad % encoding: " + this);
                }
                if (this._raw[i + 1] == 117) {
                    if (i + 5 >= this._param) {
                        throw new IllegalArgumentException("Bad %u encoding: " + this);
                    }
                    try {
                        String unicode = new String(Character.toChars(TypeUtil.parseInt(this._raw, i + 2, 4, 16)));
                        this._utf8b.getStringBuilder().append(unicode);
                        i += 5;
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                b = (byte)(0xFF & TypeUtil.parseInt(this._raw, i + 1, 2, 16));
                this._utf8b.append(b);
                i += 2;
                continue;
            }
            if (!decoding) continue;
            this._utf8b.append(b);
        }
        if (!decoding) {
            return this.toUtf8String(this._path, length);
        }
        return this._utf8b.toString();
    }

    public String getDecodedPath(String encoding) {
        if (this._path == this._param) {
            return null;
        }
        int length = this._param - this._path;
        byte[] bytes = null;
        int n = 0;
        for (int i = this._path; i < this._param; ++i) {
            byte b = this._raw[i];
            if (b == 37) {
                if (bytes == null) {
                    bytes = new byte[length];
                    System.arraycopy(this._raw, this._path, bytes, 0, n);
                }
                if (i + 2 >= this._param) {
                    throw new IllegalArgumentException("Bad % encoding: " + this);
                }
                if (this._raw[i + 1] == 117) {
                    if (i + 5 >= this._param) {
                        throw new IllegalArgumentException("Bad %u encoding: " + this);
                    }
                    try {
                        String unicode = new String(Character.toChars(TypeUtil.parseInt(this._raw, i + 2, 4, 16)));
                        byte[] encoded = unicode.getBytes(encoding);
                        System.arraycopy(encoded, 0, bytes, n, encoded.length);
                        n += encoded.length;
                        i += 5;
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                b = (byte)(0xFF & TypeUtil.parseInt(this._raw, i + 1, 2, 16));
                bytes[n++] = b;
                i += 2;
                continue;
            }
            if (bytes == null) {
                ++n;
                continue;
            }
            bytes[n++] = b;
        }
        if (bytes == null) {
            return StringUtil.toString(this._raw, this._path, this._param - this._path, encoding);
        }
        return StringUtil.toString(bytes, 0, n, encoding);
    }

    public String getPathAndParam() {
        if (this._path == this._query) {
            return null;
        }
        return this.toUtf8String(this._path, this._query - this._path);
    }

    public String getCompletePath() {
        if (this._path == this._end) {
            return null;
        }
        return this.toUtf8String(this._path, this._end - this._path);
    }

    public String getParam() {
        if (this._param == this._query) {
            return null;
        }
        return this.toUtf8String(this._param + 1, this._query - this._param - 1);
    }

    public String getQuery() {
        if (this._query == this._fragment) {
            return null;
        }
        return this.toUtf8String(this._query + 1, this._fragment - this._query - 1);
    }

    public String getQuery(String encoding) {
        if (this._query == this._fragment) {
            return null;
        }
        return StringUtil.toString(this._raw, this._query + 1, this._fragment - this._query - 1, encoding);
    }

    public boolean hasQuery() {
        return this._fragment > this._query;
    }

    public String getFragment() {
        if (this._fragment == this._end) {
            return null;
        }
        return this.toUtf8String(this._fragment + 1, this._end - this._fragment - 1);
    }

    public void decodeQueryTo(MultiMap parameters) {
        if (this._query == this._fragment) {
            return;
        }
        this._utf8b.reset();
        UrlEncoded.decodeUtf8To(this._raw, this._query + 1, this._fragment - this._query - 1, parameters, this._utf8b);
    }

    public void decodeQueryTo(MultiMap parameters, String encoding) throws UnsupportedEncodingException {
        if (this._query == this._fragment) {
            return;
        }
        if (encoding == null || StringUtil.isUTF8(encoding)) {
            UrlEncoded.decodeUtf8To(this._raw, this._query + 1, this._fragment - this._query - 1, parameters);
        } else {
            UrlEncoded.decodeTo(StringUtil.toString(this._raw, this._query + 1, this._fragment - this._query - 1, encoding), parameters, encoding);
        }
    }

    public void clear() {
        this._end = 0;
        this._fragment = 0;
        this._query = 0;
        this._param = 0;
        this._path = 0;
        this._port = 0;
        this._host = 0;
        this._authority = 0;
        this._scheme = 0;
        this._raw = __empty;
        this._rawString = "";
        this._encoded = false;
    }

    public String toString() {
        if (this._rawString == null) {
            this._rawString = this.toUtf8String(this._scheme, this._end - this._scheme);
        }
        return this._rawString;
    }

    public void writeTo(Utf8StringBuilder buf) {
        buf.append(this._raw, this._scheme, this._end - this._scheme);
    }
}

