/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.eclipse.jetty.server;

import io.warp10.sensision.jarjar.javax.servlet.DispatcherType;
import io.warp10.sensision.jarjar.javax.servlet.RequestDispatcher;
import io.warp10.sensision.jarjar.javax.servlet.ServletException;
import io.warp10.sensision.jarjar.javax.servlet.ServletRequest;
import io.warp10.sensision.jarjar.javax.servlet.ServletResponse;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletRequest;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletResponse;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.AbstractHttpConnection;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.Request;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.Response;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.ServletRequestHttpWrapper;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.ServletResponseHttpWrapper;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.handler.ContextHandler;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.Attributes;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.LazyList;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.MultiMap;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.UrlEncoded;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;

public class Dispatcher
implements RequestDispatcher {
    public static final String __INCLUDE_PREFIX = "io.warp10.sensision.jarjar.javax.servlet.include.";
    public static final String __FORWARD_PREFIX = "io.warp10.sensision.jarjar.javax.servlet.forward.";
    public static final String __JSP_FILE = "io.warp10.sensision.jarjar.org.apache.catalina.jsp_file";
    private final ContextHandler _contextHandler;
    private final String _uri;
    private final String _path;
    private final String _dQuery;
    private final String _named;

    public Dispatcher(ContextHandler contextHandler, String uri, String pathInContext, String query) {
        this._contextHandler = contextHandler;
        this._uri = uri;
        this._path = pathInContext;
        this._dQuery = query;
        this._named = null;
    }

    public Dispatcher(ContextHandler contextHandler, String name) throws IllegalStateException {
        this._contextHandler = contextHandler;
        this._named = name;
        this._uri = null;
        this._path = null;
        this._dQuery = null;
    }

    @Override
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.FORWARD);
    }

    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request baseRequest;
        Request request2 = baseRequest = request instanceof Request ? (Request)request : AbstractHttpConnection.getCurrentConnection().getRequest();
        if (!(request instanceof HttpServletRequest)) {
            request = new ServletRequestHttpWrapper(request);
        }
        if (!(response instanceof HttpServletResponse)) {
            response = new ServletResponseHttpWrapper(response);
        }
        DispatcherType old_type = baseRequest.getDispatcherType();
        Attributes old_attr = baseRequest.getAttributes();
        MultiMap<String> old_params = baseRequest.getParameters();
        try {
            baseRequest.setDispatcherType(DispatcherType.INCLUDE);
            baseRequest.getConnection().include();
            if (this._named != null) {
                this._contextHandler.handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    if (old_params == null) {
                        baseRequest.extractParameters();
                        old_params = baseRequest.getParameters();
                    }
                    MultiMap<String> parameters = new MultiMap<String>();
                    UrlEncoded.decodeTo(query, parameters, baseRequest.getCharacterEncoding());
                    if (old_params != null && old_params.size() > 0) {
                        for (Map.Entry<String, Object> entry : old_params.entrySet()) {
                            String name = entry.getKey();
                            Object values = entry.getValue();
                            for (int i = 0; i < LazyList.size(values); ++i) {
                                parameters.add(name, LazyList.get(values, i));
                            }
                        }
                    }
                    baseRequest.setParameters(parameters);
                }
                IncludeAttributes attr = new IncludeAttributes(old_attr);
                attr._requestURI = this._uri;
                attr._contextPath = this._contextHandler.getContextPath();
                attr._servletPath = null;
                attr._pathInfo = this._path;
                attr._query = query;
                baseRequest.setAttributes(attr);
                this._contextHandler.handle(this._path, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        finally {
            baseRequest.setAttributes(old_attr);
            baseRequest.getConnection().included();
            baseRequest.setParameters(old_params);
            baseRequest.setDispatcherType(old_type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forward(ServletRequest request, ServletResponse response, DispatcherType dispatch) throws ServletException, IOException {
        Request baseRequest = request instanceof Request ? (Request)request : AbstractHttpConnection.getCurrentConnection().getRequest();
        Response base_response = baseRequest.getResponse();
        response.resetBuffer();
        base_response.fwdReset();
        if (!(request instanceof HttpServletRequest)) {
            request = new ServletRequestHttpWrapper(request);
        }
        if (!(response instanceof HttpServletResponse)) {
            response = new ServletResponseHttpWrapper(response);
        }
        boolean old_handled = baseRequest.isHandled();
        String old_uri = baseRequest.getRequestURI();
        String old_context_path = baseRequest.getContextPath();
        String old_servlet_path = baseRequest.getServletPath();
        String old_path_info = baseRequest.getPathInfo();
        String old_query = baseRequest.getQueryString();
        Attributes old_attr = baseRequest.getAttributes();
        DispatcherType old_type = baseRequest.getDispatcherType();
        MultiMap<String> old_params = baseRequest.getParameters();
        try {
            baseRequest.setHandled(false);
            baseRequest.setDispatcherType(dispatch);
            if (this._named != null) {
                this._contextHandler.handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    if (old_params == null) {
                        baseRequest.extractParameters();
                        old_params = baseRequest.getParameters();
                    }
                    baseRequest.mergeQueryString(query);
                }
                ForwardAttributes attr = new ForwardAttributes(old_attr);
                if (old_attr.getAttribute("io.warp10.sensision.jarjar.javax.servlet.forward.request_uri") != null) {
                    attr._pathInfo = (String)old_attr.getAttribute("io.warp10.sensision.jarjar.javax.servlet.forward.path_info");
                    attr._query = (String)old_attr.getAttribute("io.warp10.sensision.jarjar.javax.servlet.forward.query_string");
                    attr._requestURI = (String)old_attr.getAttribute("io.warp10.sensision.jarjar.javax.servlet.forward.request_uri");
                    attr._contextPath = (String)old_attr.getAttribute("io.warp10.sensision.jarjar.javax.servlet.forward.context_path");
                    attr._servletPath = (String)old_attr.getAttribute("io.warp10.sensision.jarjar.javax.servlet.forward.servlet_path");
                } else {
                    attr._pathInfo = old_path_info;
                    attr._query = old_query;
                    attr._requestURI = old_uri;
                    attr._contextPath = old_context_path;
                    attr._servletPath = old_servlet_path;
                }
                baseRequest.setRequestURI(this._uri);
                baseRequest.setContextPath(this._contextHandler.getContextPath());
                baseRequest.setServletPath(null);
                baseRequest.setPathInfo(this._uri);
                baseRequest.setAttributes(attr);
                this._contextHandler.handle(this._path, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
                if (!baseRequest.getAsyncContinuation().isAsyncStarted()) {
                    this.commitResponse(response, baseRequest);
                }
            }
        }
        finally {
            baseRequest.setHandled(old_handled);
            baseRequest.setRequestURI(old_uri);
            baseRequest.setContextPath(old_context_path);
            baseRequest.setServletPath(old_servlet_path);
            baseRequest.setPathInfo(old_path_info);
            baseRequest.setAttributes(old_attr);
            baseRequest.setParameters(old_params);
            baseRequest.setQueryString(old_query);
            baseRequest.setDispatcherType(old_type);
        }
    }

    private void commitResponse(ServletResponse response, Request baseRequest) throws IOException {
        if (baseRequest.getResponse().isWriting()) {
            try {
                response.getWriter().close();
            }
            catch (IllegalStateException e) {
                response.getOutputStream().close();
            }
        } else {
            try {
                response.getOutputStream().close();
            }
            catch (IllegalStateException e) {
                response.getWriter().close();
            }
        }
    }

    private class IncludeAttributes
    implements Attributes {
        final Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        IncludeAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        @Override
        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.include.path_info")) {
                    return this._pathInfo;
                }
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.include.servlet_path")) {
                    return this._servletPath;
                }
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.include.context_path")) {
                    return this._contextPath;
                }
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.include.query_string")) {
                    return this._query;
                }
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.include.request_uri")) {
                    return this._requestURI;
                }
            } else if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet<String> set = new HashSet<String>();
            Enumeration<String> e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                if (name.startsWith(Dispatcher.__INCLUDE_PREFIX)) continue;
                set.add(name);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set.add("io.warp10.sensision.jarjar.javax.servlet.include.path_info");
                } else {
                    set.remove("io.warp10.sensision.jarjar.javax.servlet.include.path_info");
                }
                set.add("io.warp10.sensision.jarjar.javax.servlet.include.request_uri");
                set.add("io.warp10.sensision.jarjar.javax.servlet.include.servlet_path");
                set.add("io.warp10.sensision.jarjar.javax.servlet.include.context_path");
                if (this._query != null) {
                    set.add("io.warp10.sensision.jarjar.javax.servlet.include.query_string");
                } else {
                    set.remove("io.warp10.sensision.jarjar.javax.servlet.include.query_string");
                }
            }
            return Collections.enumeration(set);
        }

        @Override
        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("io.warp10.sensision.jarjar.javax.servlet.")) {
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.include.path_info")) {
                    this._pathInfo = (String)value;
                } else if (key.equals("io.warp10.sensision.jarjar.javax.servlet.include.request_uri")) {
                    this._requestURI = (String)value;
                } else if (key.equals("io.warp10.sensision.jarjar.javax.servlet.include.servlet_path")) {
                    this._servletPath = (String)value;
                } else if (key.equals("io.warp10.sensision.jarjar.javax.servlet.include.context_path")) {
                    this._contextPath = (String)value;
                } else if (key.equals("io.warp10.sensision.jarjar.javax.servlet.include.query_string")) {
                    this._query = (String)value;
                } else if (value == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value);
                }
            } else if (value == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "INCLUDE+" + this._attr.toString();
        }

        @Override
        public void clearAttributes() {
            throw new IllegalStateException();
        }

        @Override
        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }

    private class ForwardAttributes
    implements Attributes {
        final Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        ForwardAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        @Override
        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.forward.path_info")) {
                    return this._pathInfo;
                }
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.forward.request_uri")) {
                    return this._requestURI;
                }
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.forward.servlet_path")) {
                    return this._servletPath;
                }
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.forward.context_path")) {
                    return this._contextPath;
                }
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.forward.query_string")) {
                    return this._query;
                }
            }
            if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet<String> set = new HashSet<String>();
            Enumeration<String> e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                if (name.startsWith(Dispatcher.__INCLUDE_PREFIX) || name.startsWith(Dispatcher.__FORWARD_PREFIX)) continue;
                set.add(name);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set.add("io.warp10.sensision.jarjar.javax.servlet.forward.path_info");
                } else {
                    set.remove("io.warp10.sensision.jarjar.javax.servlet.forward.path_info");
                }
                set.add("io.warp10.sensision.jarjar.javax.servlet.forward.request_uri");
                set.add("io.warp10.sensision.jarjar.javax.servlet.forward.servlet_path");
                set.add("io.warp10.sensision.jarjar.javax.servlet.forward.context_path");
                if (this._query != null) {
                    set.add("io.warp10.sensision.jarjar.javax.servlet.forward.query_string");
                } else {
                    set.remove("io.warp10.sensision.jarjar.javax.servlet.forward.query_string");
                }
            }
            return Collections.enumeration(set);
        }

        @Override
        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("io.warp10.sensision.jarjar.javax.servlet.")) {
                if (key.equals("io.warp10.sensision.jarjar.javax.servlet.forward.path_info")) {
                    this._pathInfo = (String)value;
                } else if (key.equals("io.warp10.sensision.jarjar.javax.servlet.forward.request_uri")) {
                    this._requestURI = (String)value;
                } else if (key.equals("io.warp10.sensision.jarjar.javax.servlet.forward.servlet_path")) {
                    this._servletPath = (String)value;
                } else if (key.equals("io.warp10.sensision.jarjar.javax.servlet.forward.context_path")) {
                    this._contextPath = (String)value;
                } else if (key.equals("io.warp10.sensision.jarjar.javax.servlet.forward.query_string")) {
                    this._query = (String)value;
                } else if (value == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value);
                }
            } else if (value == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "FORWARD+" + this._attr.toString();
        }

        @Override
        public void clearAttributes() {
            throw new IllegalStateException();
        }

        @Override
        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }
}

