/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.eclipse.jetty.server.handler.jmx;

import io.warp10.sensision.jarjar.org.eclipse.jetty.jmx.ObjectMBean;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.Server;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.handler.AbstractHandler;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import io.warp10.sensision.jarjar.org.eclipse.jetty.server.handler.ContextHandler;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.log.Log;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;

public class AbstractHandlerMBean
extends ObjectMBean {
    private static final Logger LOG = Log.getLogger(AbstractHandlerMBean.class);

    public AbstractHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    public String getObjectContextBasis() {
        if (this._managed != null) {
            ContextHandler context;
            AbstractHandler handler;
            Server server;
            String basis = null;
            if (this._managed instanceof ContextHandler) {
                return null;
            }
            if (this._managed instanceof AbstractHandler && (server = (handler = (AbstractHandler)this._managed).getServer()) != null && (context = AbstractHandlerContainer.findContainerOf(server, ContextHandler.class, handler)) != null) {
                basis = this.getContextName(context);
            }
            if (basis != null) {
                return basis;
            }
        }
        return super.getObjectContextBasis();
    }

    public String getObjectNameBasis() {
        if (this._managed != null) {
            String name = null;
            if (this._managed instanceof ContextHandler) {
                ContextHandler context = (ContextHandler)this._managed;
                name = this.getContextName(context);
            }
            if (name != null) {
                return name;
            }
        }
        return super.getObjectNameBasis();
    }

    protected String getContextName(ContextHandler context) {
        String name = null;
        if (context.getContextPath() != null && context.getContextPath().length() > 0) {
            int idx = context.getContextPath().lastIndexOf(47);
            String string = name = idx < 0 ? context.getContextPath() : context.getContextPath().substring(++idx);
            if (name == null || name.length() == 0) {
                name = "ROOT";
            }
        }
        if (name == null && context.getBaseResource() != null) {
            try {
                if (context.getBaseResource().getFile() != null) {
                    name = context.getBaseResource().getFile().getName();
                }
            }
            catch (IOException e) {
                LOG.ignore(e);
                name = context.getBaseResource().getName();
            }
        }
        return name;
    }
}

