/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.eclipse.jetty.util.resource;

import io.warp10.sensision.jarjar.org.eclipse.jetty.util.log.Log;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.log.Logger;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.resource.JarResource;
import io.warp10.sensision.jarjar.org.eclipse.jetty.util.resource.Resource;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class JarFileResource
extends JarResource {
    private static final Logger LOG = Log.getLogger(JarFileResource.class);
    private JarFile _jarFile;
    private File _file;
    private String[] _list;
    private JarEntry _entry;
    private boolean _directory;
    private String _jarUrl;
    private String _path;
    private boolean _exists;

    JarFileResource(URL url) {
        super(url);
    }

    JarFileResource(URL url, boolean useCaches) {
        super(url, useCaches);
    }

    @Override
    public synchronized void release() {
        this._list = null;
        this._entry = null;
        this._file = null;
        if (!this.getUseCaches() && this._jarFile != null) {
            try {
                LOG.debug("Closing JarFile " + this._jarFile.getName(), new Object[0]);
                this._jarFile.close();
            }
            catch (IOException ioe) {
                LOG.ignore(ioe);
            }
        }
        this._jarFile = null;
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkConnection() {
        try {
            super.checkConnection();
        }
        finally {
            if (this._jarConnection == null) {
                this._entry = null;
                this._file = null;
                this._jarFile = null;
                this._list = null;
            }
        }
        return this._jarFile != null;
    }

    @Override
    protected synchronized void newConnection() throws IOException {
        super.newConnection();
        this._entry = null;
        this._file = null;
        this._jarFile = null;
        this._list = null;
        int sep = this._urlString.indexOf("!/");
        this._jarUrl = this._urlString.substring(0, sep + 2);
        this._path = this._urlString.substring(sep + 2);
        if (this._path.length() == 0) {
            this._path = null;
        }
        this._jarFile = this._jarConnection.getJarFile();
        this._file = new File(this._jarFile.getName());
    }

    @Override
    public boolean exists() {
        if (this._exists) {
            return true;
        }
        if (this._urlString.endsWith("!/")) {
            String file_url = this._urlString.substring(4, this._urlString.length() - 2);
            try {
                return JarFileResource.newResource(file_url).exists();
            }
            catch (Exception e) {
                LOG.ignore(e);
                return false;
            }
        }
        boolean check = this.checkConnection();
        if (this._jarUrl != null && this._path == null) {
            this._directory = check;
            return true;
        }
        JarFile jarFile = null;
        if (check) {
            jarFile = this._jarFile;
        } else {
            try {
                JarURLConnection c = (JarURLConnection)new URL(this._jarUrl).openConnection();
                c.setUseCaches(this.getUseCaches());
                jarFile = c.getJarFile();
            }
            catch (Exception e) {
                LOG.ignore(e);
            }
        }
        if (jarFile != null && this._entry == null && !this._directory) {
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName().replace('\\', '/');
                if (name.equals(this._path)) {
                    this._entry = entry;
                    this._directory = this._path.endsWith("/");
                    break;
                }
                if (this._path.endsWith("/")) {
                    if (!name.startsWith(this._path)) continue;
                    this._directory = true;
                    break;
                }
                if (!name.startsWith(this._path) || name.length() <= this._path.length() || name.charAt(this._path.length()) != '/') continue;
                this._directory = true;
                break;
            }
            if (this._directory && !this._urlString.endsWith("/")) {
                this._urlString = this._urlString + "/";
                try {
                    this._url = new URL(this._urlString);
                }
                catch (MalformedURLException ex) {
                    LOG.warn(ex);
                }
            }
        }
        this._exists = this._directory || this._entry != null;
        return this._exists;
    }

    @Override
    public boolean isDirectory() {
        return this._urlString.endsWith("/") || this.exists() && this._directory;
    }

    @Override
    public long lastModified() {
        if (this.checkConnection() && this._file != null) {
            if (this.exists() && this._entry != null) {
                return this._entry.getTime();
            }
            return this._file.lastModified();
        }
        return -1L;
    }

    @Override
    public synchronized String[] list() {
        if (this.isDirectory() && this._list == null) {
            List<String> list = null;
            try {
                list = this.listEntries();
            }
            catch (Exception e) {
                LOG.warn("Retrying list:" + e, new Object[0]);
                LOG.debug(e);
                this.release();
                list = this.listEntries();
            }
            if (list != null) {
                this._list = new String[list.size()];
                list.toArray(this._list);
            }
        }
        return this._list;
    }

    private List<String> listEntries() {
        this.checkConnection();
        ArrayList<String> list = new ArrayList<String>(32);
        JarFile jarFile = this._jarFile;
        if (jarFile == null) {
            try {
                JarURLConnection jc = (JarURLConnection)new URL(this._jarUrl).openConnection();
                jc.setUseCaches(this.getUseCaches());
                jarFile = jc.getJarFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.ignore(e);
            }
        }
        Enumeration<JarEntry> e = jarFile.entries();
        String dir = this._urlString.substring(this._urlString.indexOf("!/") + 2);
        while (e.hasMoreElements()) {
            String listName;
            int dash;
            JarEntry entry = e.nextElement();
            String name = entry.getName().replace('\\', '/');
            if (!name.startsWith(dir) || name.length() == dir.length() || (dash = (listName = name.substring(dir.length())).indexOf(47)) >= 0 && (dash == 0 && listName.length() == 1 || list.contains(listName = dash == 0 ? listName.substring(dash + 1, listName.length()) : listName.substring(0, dash + 1)))) continue;
            list.add(listName);
        }
        return list;
    }

    @Override
    public long length() {
        if (this.isDirectory()) {
            return -1L;
        }
        if (this._entry != null) {
            return this._entry.getSize();
        }
        return -1L;
    }

    @Override
    public String encode(String uri) {
        return uri;
    }

    public static Resource getNonCachingResource(Resource resource) {
        if (!(resource instanceof JarFileResource)) {
            return resource;
        }
        JarFileResource oldResource = (JarFileResource)resource;
        JarFileResource newResource = new JarFileResource(oldResource.getURL(), false);
        return newResource;
    }

    @Override
    public boolean isContainedIn(Resource resource) throws MalformedURLException {
        String string = this._urlString;
        int index = string.indexOf("!/");
        if (index > 0) {
            string = string.substring(0, index);
        }
        if (string.startsWith("jar:")) {
            string = string.substring(4);
        }
        URL url = new URL(string);
        return url.sameFile(resource.getURL());
    }
}

