/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.mortbay.jetty.handler;

import io.warp10.sensision.jarjar.javax.servlet.ServletException;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletRequest;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletResponse;
import io.warp10.sensision.jarjar.org.mortbay.jetty.HandlerContainer;
import io.warp10.sensision.jarjar.org.mortbay.jetty.HttpConnection;
import io.warp10.sensision.jarjar.org.mortbay.jetty.Request;
import io.warp10.sensision.jarjar.org.mortbay.jetty.handler.AbstractHandler;
import io.warp10.sensision.jarjar.org.mortbay.jetty.handler.ContextHandler;
import io.warp10.sensision.jarjar.org.mortbay.util.URIUtil;
import java.io.IOException;

public class MovedContextHandler
extends ContextHandler {
    String _newContextURL;
    boolean _discardPathInfo;
    boolean _discardQuery;
    boolean _permanent;
    Redirector _redirector;

    public MovedContextHandler() {
        this._redirector = new Redirector();
        this.addHandler(this._redirector);
    }

    public MovedContextHandler(HandlerContainer parent, String contextPath, String newContextURL) {
        super(parent, contextPath);
        this._newContextURL = newContextURL;
        this._redirector = new Redirector();
        this.addHandler(this._redirector);
    }

    public boolean isDiscardPathInfo() {
        return this._discardPathInfo;
    }

    public void setDiscardPathInfo(boolean discardPathInfo) {
        this._discardPathInfo = discardPathInfo;
    }

    public String getNewContextURL() {
        return this._newContextURL;
    }

    public void setNewContextURL(String newContextURL) {
        this._newContextURL = newContextURL;
    }

    public boolean isPermanent() {
        return this._permanent;
    }

    public void setPermanent(boolean permanent) {
        this._permanent = permanent;
    }

    public boolean isDiscardQuery() {
        return this._discardQuery;
    }

    public void setDiscardQuery(boolean discardQuery) {
        this._discardQuery = discardQuery;
    }

    private class Redirector
    extends AbstractHandler {
        private Redirector() {
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            if (MovedContextHandler.this._newContextURL == null) {
                return;
            }
            Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
            String url = MovedContextHandler.this._newContextURL;
            if (!MovedContextHandler.this._discardPathInfo && request.getPathInfo() != null) {
                url = URIUtil.addPaths(url, request.getPathInfo());
            }
            if (!MovedContextHandler.this._discardQuery && request.getQueryString() != null) {
                url = url + "?" + request.getQueryString();
            }
            response.sendRedirect(url);
            if (MovedContextHandler.this._permanent) {
                response.setStatus(301);
            }
            base_request.setHandled(true);
        }
    }
}

