/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.mortbay.jetty.security;

import io.warp10.sensision.jarjar.javax.servlet.ServletException;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletRequest;
import io.warp10.sensision.jarjar.javax.servlet.http.HttpServletResponse;
import io.warp10.sensision.jarjar.org.mortbay.jetty.Handler;
import io.warp10.sensision.jarjar.org.mortbay.jetty.HttpConnection;
import io.warp10.sensision.jarjar.org.mortbay.jetty.Request;
import io.warp10.sensision.jarjar.org.mortbay.jetty.Response;
import io.warp10.sensision.jarjar.org.mortbay.jetty.handler.ContextHandler;
import io.warp10.sensision.jarjar.org.mortbay.jetty.security.B64Code;
import io.warp10.sensision.jarjar.org.mortbay.jetty.security.SecurityHandler;
import io.warp10.sensision.jarjar.org.mortbay.jetty.security.UnixCrypt;
import io.warp10.sensision.jarjar.org.mortbay.jetty.security.UserRealm;
import io.warp10.sensision.jarjar.org.mortbay.log.Log;
import io.warp10.sensision.jarjar.org.mortbay.log.Logger;
import io.warp10.sensision.jarjar.org.mortbay.resource.Resource;
import io.warp10.sensision.jarjar.org.mortbay.util.StringUtil;
import io.warp10.sensision.jarjar.org.mortbay.util.URIUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;

public class HTAccessHandler
extends SecurityHandler {
    private Handler protegee;
    private static Logger log = Log.getLogger(HTAccessHandler.class.getName());
    String _default = null;
    String _accessFile = ".htaccess";
    transient HashMap _htCache = new HashMap();

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        block21: {
            String credentials;
            Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
            Response base_response = response instanceof Response ? (Response)response : HttpConnection.getCurrentConnection().getResponse();
            String pathInContext = target;
            String user = null;
            String password = null;
            boolean IPValid = true;
            if (log.isDebugEnabled()) {
                log.debug("HTAccessHandler pathInContext=" + pathInContext, null, null);
            }
            if ((credentials = request.getHeader("Authorization")) != null) {
                credentials = credentials.substring(credentials.indexOf(32) + 1);
                credentials = B64Code.decode(credentials, StringUtil.__ISO_8859_1);
                int i = credentials.indexOf(58);
                user = credentials.substring(0, i);
                password = credentials.substring(i + 1);
                if (log.isDebugEnabled()) {
                    log.debug("User=" + user + ", password=" + "******************************".substring(0, password.length()), null, null);
                }
            }
            HTAccess ht = null;
            try {
                String directory;
                Resource resource = null;
                String string = directory = pathInContext.endsWith("/") ? pathInContext : URIUtil.parentPath(pathInContext);
                while (directory != null) {
                    String htPath = directory + this._accessFile;
                    resource = ((ContextHandler)this.getProtegee()).getResource(htPath);
                    if (log.isDebugEnabled()) {
                        log.debug("directory=" + directory + " resource=" + resource, null, null);
                    }
                    if (resource != null && resource.exists() && !resource.isDirectory()) break;
                    resource = null;
                    directory = URIUtil.parentPath(directory);
                }
                boolean haveHtAccess = true;
                if (resource == null && this._default != null && (!(resource = Resource.newResource(this._default)).exists() || resource.isDirectory())) {
                    haveHtAccess = false;
                }
                if (resource == null) {
                    haveHtAccess = false;
                }
                if (pathInContext.endsWith(this._accessFile) || pathInContext.endsWith(this._accessFile + "~") || pathInContext.endsWith(this._accessFile + ".bak")) {
                    response.sendError(403);
                    base_request.setHandled(true);
                    return;
                }
                if (haveHtAccess) {
                    if (log.isDebugEnabled()) {
                        log.debug("HTACCESS=" + resource, null, null);
                    }
                    if ((ht = (HTAccess)this._htCache.get(resource)) == null || ht.getLastModified() != resource.lastModified()) {
                        ht = new HTAccess(resource);
                        this._htCache.put(resource, ht);
                        if (log.isDebugEnabled()) {
                            log.debug("HTCache loaded " + ht, null, null);
                        }
                    }
                    if (ht.isForbidden()) {
                        log.warn("Mis-configured htaccess: " + ht, null, null);
                        response.sendError(403);
                        base_request.setHandled(true);
                        return;
                    }
                    HashMap methods = ht.getMethods();
                    if (methods.size() > 0 && !methods.containsKey(request.getMethod())) {
                        this.callWrappedHandler(target, request, response, dispatch);
                        return;
                    }
                    int satisfy = ht.getSatisfy();
                    IPValid = ht.checkAccess("", request.getRemoteAddr());
                    if (log.isDebugEnabled()) {
                        log.debug("IPValid = " + IPValid, null, null);
                    }
                    if (IPValid && satisfy == 0) {
                        this.callWrappedHandler(target, request, response, dispatch);
                        return;
                    }
                    if (!IPValid && satisfy == 1) {
                        response.sendError(403);
                        base_request.setHandled(true);
                        return;
                    }
                    if (!ht.checkAuth(user, password, this.getUserRealm(), base_request)) {
                        log.debug("Auth Failed", null, null);
                        response.setHeader("WWW-Authenticate", "basic realm=" + ht.getName());
                        response.sendError(401);
                        base_response.complete();
                        base_request.setHandled(true);
                        return;
                    }
                    if (user != null) {
                        base_request.setAuthType("BASIC");
                        base_request.setUserPrincipal(this.getPrincipal(user, this.getUserRealm()));
                    }
                }
                this.callWrappedHandler(target, request, response, dispatch);
            }
            catch (Exception ex) {
                log.warn("Exception", ex);
                if (ht == null) break block21;
                response.sendError(500);
                base_request.setHandled(true);
            }
        }
    }

    private void callWrappedHandler(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.handle(target, request, response, dispatch);
        }
    }

    public Principal getPrincipal(String user, UserRealm realm) {
        if (realm == null) {
            return new DummyPrincipal(user);
        }
        return realm.getPrincipal(user);
    }

    public void setDefault(String dir) {
        this._default = dir;
    }

    public void setAccessFile(String anArg) {
        this._accessFile = anArg == null ? ".htaccess" : anArg;
    }

    protected Handler getProtegee() {
        return this.protegee;
    }

    public void setProtegee(Handler protegee) {
        this.protegee = protegee;
    }

    private static class HTAccess {
        static final int ANY = 0;
        static final int ALL = 1;
        static final String USER = "user";
        static final String GROUP = "group";
        static final String VALID_USER = "valid-user";
        String _userFile;
        Resource _userResource;
        HashMap _users = null;
        long _userModified;
        String _groupFile;
        Resource _groupResource;
        HashMap _groups = null;
        long _groupModified;
        int _satisfy = 0;
        String _type;
        String _name;
        HashMap _methods = new HashMap();
        HashSet _requireEntities = new HashSet();
        String _requireName;
        int _order;
        ArrayList _allowList = new ArrayList();
        ArrayList _denyList = new ArrayList();
        long _lastModified;
        boolean _forbidden = false;

        public HTAccess(Resource resource) {
            BufferedReader htin = null;
            try {
                htin = new BufferedReader(new InputStreamReader(resource.getInputStream()));
                this.parse(htin);
                this._lastModified = resource.lastModified();
                if (this._userFile != null) {
                    this._userResource = Resource.newResource(this._userFile);
                    if (!this._userResource.exists()) {
                        this._forbidden = true;
                        log.warn("Could not find ht user file: " + this._userFile, null, null);
                    } else if (log.isDebugEnabled()) {
                        log.debug("user file: " + this._userResource, null, null);
                    }
                }
                if (this._groupFile != null) {
                    this._groupResource = Resource.newResource(this._groupFile);
                    if (!this._groupResource.exists()) {
                        this._forbidden = true;
                        log.warn("Could not find ht group file: " + this._groupResource, null, null);
                    } else if (log.isDebugEnabled()) {
                        log.debug("group file: " + this._groupResource, null, null);
                    }
                }
            }
            catch (IOException e) {
                this._forbidden = true;
                log.warn("LogSupport.EXCEPTION", e);
            }
        }

        public boolean isForbidden() {
            return this._forbidden;
        }

        public HashMap getMethods() {
            return this._methods;
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public Resource getUserResource() {
            return this._userResource;
        }

        public Resource getGroupResource() {
            return this._groupResource;
        }

        public int getSatisfy() {
            return this._satisfy;
        }

        public String getName() {
            return this._name;
        }

        public String getType() {
            return this._type;
        }

        public boolean checkAccess(String host, String ip) {
            char c;
            String elm;
            int i;
            boolean alp = false;
            boolean dep = false;
            if (this._allowList.size() == 0 && this._denyList.size() == 0) {
                return true;
            }
            for (i = 0; i < this._allowList.size(); ++i) {
                elm = (String)this._allowList.get(i);
                if (elm.equals("all")) {
                    alp = true;
                    break;
                }
                c = elm.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (!ip.startsWith(elm)) continue;
                    alp = true;
                    break;
                }
                if (!host.endsWith(elm)) continue;
                alp = true;
                break;
            }
            for (i = 0; i < this._denyList.size(); ++i) {
                elm = (String)this._denyList.get(i);
                if (elm.equals("all")) {
                    dep = true;
                    break;
                }
                c = elm.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (!ip.startsWith(elm)) continue;
                    dep = true;
                    break;
                }
                if (!host.endsWith(elm)) continue;
                dep = true;
                break;
            }
            if (this._order < 0) {
                return !dep || alp;
            }
            return alp && !dep;
        }

        public boolean checkAuth(String user, String pass, UserRealm realm, Request request) {
            Principal principal;
            if (this._requireName == null) {
                return true;
            }
            Principal principal2 = principal = realm == null ? null : realm.authenticate(user, pass, request);
            if (principal == null) {
                String cred;
                String code = this.getUserCode(user);
                String salt = code != null ? code.substring(0, 2) : user;
                String string = cred = user != null && pass != null ? UnixCrypt.crypt(pass, salt) : null;
                if (code == null || code.equals("") && !pass.equals("") || !code.equals(cred)) {
                    return false;
                }
            }
            if (this._requireName.equalsIgnoreCase(USER)) {
                if (this._requireEntities.contains(user)) {
                    return true;
                }
            } else if (this._requireName.equalsIgnoreCase(GROUP)) {
                ArrayList gps = this.getUserGroups(user);
                if (gps != null) {
                    int g = gps.size();
                    while (g-- > 0) {
                        if (!this._requireEntities.contains(gps.get(g))) continue;
                        return true;
                    }
                }
            } else if (this._requireName.equalsIgnoreCase(VALID_USER)) {
                return true;
            }
            return false;
        }

        public boolean isAccessLimited() {
            return this._allowList.size() > 0 || this._denyList.size() > 0;
        }

        public boolean isAuthLimited() {
            return this._requireName != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private String getUserCode(String user) {
            block15: {
                if (this._userResource == null) {
                    return null;
                }
                if (this._users == null || this._userModified != this._userResource.lastModified()) {
                    String line;
                    if (log.isDebugEnabled()) {
                        log.debug("LOAD " + this._userResource, null, null);
                    }
                    this._users = new HashMap();
                    BufferedReader ufin = null;
                    ufin = new BufferedReader(new InputStreamReader(this._userResource.getInputStream()));
                    this._userModified = this._userResource.lastModified();
                    while ((line = ufin.readLine()) != null) {
                        int spos;
                        if ((line = line.trim()).startsWith("#") || (spos = line.indexOf(58)) < 0) continue;
                        String u = line.substring(0, spos).trim();
                        String p = line.substring(spos + 1).trim();
                        this._users.put(u, p);
                    }
                    Object var8_8 = null;
                    try {
                        if (ufin != null) {
                            ufin.close();
                        }
                        break block15;
                    }
                    catch (IOException e2) {
                        log.warn("LogSupport.EXCEPTION", e2);
                    }
                    break block15;
                    {
                        catch (IOException e) {
                            log.warn("LogSupport.EXCEPTION", e);
                            Object var8_9 = null;
                            try {
                                if (ufin != null) {
                                    ufin.close();
                                }
                                break block15;
                            }
                            catch (IOException e2) {
                                log.warn("LogSupport.EXCEPTION", e2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        try {
                            if (ufin != null) {
                                ufin.close();
                            }
                        }
                        catch (IOException e2) {
                            log.warn("LogSupport.EXCEPTION", e2);
                        }
                        throw throwable;
                    }
                }
            }
            return (String)this._users.get(user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private ArrayList getUserGroups(String group) {
            block17: {
                if (this._groupResource == null) {
                    return null;
                }
                if (this._groups == null || this._groupModified != this._groupResource.lastModified()) {
                    String line;
                    if (log.isDebugEnabled()) {
                        log.debug("LOAD " + this._groupResource, null, null);
                    }
                    this._groups = new HashMap();
                    BufferedReader ufin = null;
                    ufin = new BufferedReader(new InputStreamReader(this._groupResource.getInputStream()));
                    this._groupModified = this._groupResource.lastModified();
                    while ((line = ufin.readLine()) != null) {
                        StringTokenizer tok;
                        if ((line = line.trim()).startsWith("#") || line.length() == 0 || !(tok = new StringTokenizer(line, ": \t")).hasMoreTokens()) continue;
                        String g = tok.nextToken();
                        if (!tok.hasMoreTokens()) continue;
                        while (tok.hasMoreTokens()) {
                            String u = tok.nextToken();
                            ArrayList<String> gl = (ArrayList<String>)this._groups.get(u);
                            if (gl == null) {
                                gl = new ArrayList<String>();
                                this._groups.put(u, gl);
                            }
                            gl.add(g);
                        }
                    }
                    Object var9_9 = null;
                    try {
                        if (ufin != null) {
                            ufin.close();
                        }
                        break block17;
                    }
                    catch (IOException e2) {
                        log.warn("LogSupport.EXCEPTION", e2);
                    }
                    break block17;
                    {
                        catch (IOException e) {
                            log.warn("LogSupport.EXCEPTION", e);
                            Object var9_10 = null;
                            try {
                                if (ufin != null) {
                                    ufin.close();
                                }
                                break block17;
                            }
                            catch (IOException e2) {
                                log.warn("LogSupport.EXCEPTION", e2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        try {
                            if (ufin != null) {
                                ufin.close();
                            }
                        }
                        catch (IOException e2) {
                            log.warn("LogSupport.EXCEPTION", e2);
                        }
                        throw throwable;
                    }
                }
            }
            return (ArrayList)this._groups.get(group);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("AuthUserFile=");
            buf.append(this._userFile);
            buf.append(", AuthGroupFile=");
            buf.append(this._groupFile);
            buf.append(", AuthName=");
            buf.append(this._name);
            buf.append(", AuthType=");
            buf.append(this._type);
            buf.append(", Methods=");
            buf.append(this._methods);
            buf.append(", satisfy=");
            buf.append(this._satisfy);
            if (this._order < 0) {
                buf.append(", order=deny,allow");
            } else if (this._order > 0) {
                buf.append(", order=allow,deny");
            } else {
                buf.append(", order=mutual-failure");
            }
            buf.append(", Allow from=");
            buf.append(this._allowList);
            buf.append(", deny from=");
            buf.append(this._denyList);
            buf.append(", requireName=");
            buf.append(this._requireName);
            buf.append(" ");
            buf.append(this._requireEntities);
            return buf.toString();
        }

        private void parse(BufferedReader htin) throws IOException {
            String line;
            block0: while ((line = htin.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.startsWith("AuthUserFile")) {
                    this._userFile = line.substring(13).trim();
                    continue;
                }
                if (line.startsWith("AuthGroupFile")) {
                    this._groupFile = line.substring(14).trim();
                    continue;
                }
                if (line.startsWith("AuthName")) {
                    this._name = line.substring(8).trim();
                    continue;
                }
                if (line.startsWith("AuthType")) {
                    this._type = line.substring(8).trim();
                    continue;
                }
                if (!line.startsWith("<Limit")) continue;
                int limit = line.length();
                int endp = line.indexOf(62);
                if (endp < 0) {
                    endp = limit;
                }
                StringTokenizer tkns = new StringTokenizer(line.substring(6, endp));
                while (tkns.hasMoreTokens()) {
                    this._methods.put(tkns.nextToken(), Boolean.TRUE);
                }
                while ((line = htin.readLine()) != null) {
                    int pos2;
                    int pos1;
                    if ((line = line.trim()).startsWith("#")) continue;
                    if (line.startsWith("satisfy")) {
                        limit = line.length();
                        for (pos1 = 7; pos1 < limit && line.charAt(pos1) <= ' '; ++pos1) {
                        }
                        for (pos2 = pos1; pos2 < limit && line.charAt(pos2) > ' '; ++pos2) {
                        }
                        String l_string = line.substring(pos1, pos2);
                        if (l_string.equals("all")) {
                            this._satisfy = 1;
                            continue;
                        }
                        if (!l_string.equals("any")) continue;
                        this._satisfy = 0;
                        continue;
                    }
                    if (line.startsWith("require")) {
                        limit = line.length();
                        for (pos1 = 7; pos1 < limit && line.charAt(pos1) <= ' '; ++pos1) {
                        }
                        for (pos2 = pos1; pos2 < limit && line.charAt(pos2) > ' '; ++pos2) {
                        }
                        this._requireName = line.substring(pos1, pos2).toLowerCase();
                        if (USER.equals(this._requireName)) {
                            this._requireName = USER;
                        } else if (GROUP.equals(this._requireName)) {
                            this._requireName = GROUP;
                        } else if (VALID_USER.equals(this._requireName)) {
                            this._requireName = VALID_USER;
                        }
                        if ((pos1 = pos2 + 1) >= limit) continue;
                        while (pos1 < limit && line.charAt(pos1) <= ' ') {
                            ++pos1;
                        }
                        tkns = new StringTokenizer(line.substring(pos1));
                        while (tkns.hasMoreTokens()) {
                            this._requireEntities.add(tkns.nextToken());
                        }
                        continue;
                    }
                    if (line.startsWith("order")) {
                        if (log.isDebugEnabled()) {
                            log.debug("orderline=" + line + "order=" + this._order, null, null);
                        }
                        if (line.indexOf("allow,deny") > 0) {
                            log.debug("==>allow+deny", null, null);
                            this._order = 1;
                            continue;
                        }
                        if (line.indexOf("deny,allow") > 0) {
                            log.debug("==>deny,allow", null, null);
                            this._order = -1;
                            continue;
                        }
                        if (line.indexOf("mutual-failure") <= 0) continue;
                        log.debug("==>mutual", null, null);
                        this._order = 0;
                        continue;
                    }
                    if (line.startsWith("allow from")) {
                        limit = line.length();
                        for (pos1 = 10; pos1 < limit && line.charAt(pos1) <= ' '; ++pos1) {
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("allow process:" + line.substring(pos1), null, null);
                        }
                        tkns = new StringTokenizer(line.substring(pos1));
                        while (tkns.hasMoreTokens()) {
                            this._allowList.add(tkns.nextToken());
                        }
                        continue;
                    }
                    if (line.startsWith("deny from")) {
                        limit = line.length();
                        for (pos1 = 9; pos1 < limit && line.charAt(pos1) <= ' '; ++pos1) {
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("deny process:" + line.substring(pos1), null, null);
                        }
                        tkns = new StringTokenizer(line.substring(pos1));
                        while (tkns.hasMoreTokens()) {
                            this._denyList.add(tkns.nextToken());
                        }
                        continue;
                    }
                    if (!line.startsWith("</Limit>")) continue;
                    continue block0;
                }
            }
        }
    }

    class DummyPrincipal
    implements Principal {
        private String _userName;

        public DummyPrincipal(String name) {
            this._userName = name;
        }

        public String getName() {
            return this._userName;
        }

        public String toString() {
            return this.getName();
        }
    }
}

