/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.mortbay.thread;

import io.warp10.sensision.jarjar.org.mortbay.component.AbstractLifeCycle;
import io.warp10.sensision.jarjar.org.mortbay.log.Log;
import io.warp10.sensision.jarjar.org.mortbay.thread.ThreadPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class BoundedThreadPool
extends AbstractLifeCycle
implements Serializable,
ThreadPool {
    private static int __id;
    private boolean _daemon;
    private int _id;
    private List _idle;
    private final Object _lock = new Object();
    private final Object _joinLock = new Object();
    private long _lastShrink;
    private int _maxIdleTimeMs = 60000;
    private int _maxThreads = 255;
    private int _minThreads = 1;
    private String _name = "btpool" + __id++;
    private List _queue;
    private Set _threads;
    private boolean _warned = false;
    int _lowThreads = 0;
    int _priority = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(Runnable job) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isRunning() || job == null) {
                return false;
            }
            int idle = this._idle.size();
            if (idle > 0) {
                PoolThread thread = (PoolThread)this._idle.remove(idle - 1);
                thread.dispatch(job);
            } else if (this._threads.size() < this._maxThreads) {
                this.newThread(job);
            } else {
                if (!this._warned) {
                    this._warned = true;
                    Log.debug("Out of threads for {}", this);
                }
                this._queue.add(job);
            }
        }
        return true;
    }

    public int getIdleThreads() {
        return this._idle == null ? 0 : this._idle.size();
    }

    public int getLowThreads() {
        return this._lowThreads;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    public int getThreads() {
        return this._threads.size();
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        Object object = this._lock;
        synchronized (object) {
            return this._queue.size();
        }
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLowOnThreads() {
        Object object = this._lock;
        synchronized (object) {
            return this._queue.size() > this._lowThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(10L);
        }
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setLowThreads(int lowThreads) {
        this._lowThreads = lowThreads;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public void setMaxThreads(int maxThreads) {
        if (this.isStarted() && maxThreads < this._minThreads) {
            throw new IllegalArgumentException("!minThreads<maxThreads");
        }
        this._maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinThreads(int minThreads) {
        if (this.isStarted() && (minThreads <= 0 || minThreads > this._maxThreads)) {
            throw new IllegalArgumentException("!0<=minThreads<maxThreads");
        }
        this._minThreads = minThreads;
        Object object = this._lock;
        synchronized (object) {
            while (this.isStarted() && this._threads.size() < this._minThreads) {
                this.newThread(null);
            }
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    protected void doStart() throws Exception {
        if (this._maxThreads < this._minThreads || this._minThreads <= 0) {
            throw new IllegalArgumentException("!0<minThreads<maxThreads");
        }
        this._threads = new HashSet();
        this._idle = new ArrayList();
        this._queue = new LinkedList();
        for (int i = 0; i < this._minThreads; ++i) {
            this.newThread(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        for (int i = 0; i < 100; ++i) {
            Object object = this._lock;
            synchronized (object) {
                Iterator iter = this._threads.iterator();
                while (iter.hasNext()) {
                    ((Thread)iter.next()).interrupt();
                }
            }
            Thread.yield();
            if (this._threads.size() == 0) break;
            try {
                Thread.sleep(i * 100);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this._threads.size() > 0) {
            Log.warn(this._threads.size() + " threads could not be stopped");
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PoolThread newThread(Runnable job) {
        Object object = this._lock;
        synchronized (object) {
            PoolThread thread = new PoolThread(job);
            this._threads.add(thread);
            thread.setName(this._name + "-" + this._id++);
            thread.start();
            return thread;
        }
    }

    protected void stopJob(Thread thread, Object job) {
        thread.interrupt();
    }

    public class PoolThread
    extends Thread {
        Runnable _job = null;

        PoolThread() {
            this.setDaemon(BoundedThreadPool.this._daemon);
            this.setPriority(BoundedThreadPool.this._priority);
        }

        PoolThread(Runnable job) {
            this.setDaemon(BoundedThreadPool.this._daemon);
            this.setPriority(BoundedThreadPool.this._priority);
            this._job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block31: {
                block30: {
                    try {
                        Runnable job = null;
                        PoolThread poolThread = this;
                        synchronized (poolThread) {
                            job = this._job;
                            this._job = null;
                        }
                        while (BoundedThreadPool.this.isRunning()) {
                            Object object;
                            Object var9_5;
                            Object todo;
                            if (job != null) {
                                todo = job;
                                job = null;
                                todo.run();
                                continue;
                            }
                            todo = BoundedThreadPool.this._lock;
                            synchronized (todo) {
                                long now;
                                if (BoundedThreadPool.this._queue.size() > 0) {
                                    job = (Runnable)BoundedThreadPool.this._queue.remove(0);
                                    continue;
                                }
                                BoundedThreadPool.this._warned = false;
                                if ((BoundedThreadPool.this._threads.size() > BoundedThreadPool.this._maxThreads || BoundedThreadPool.this._idle.size() > 0 && BoundedThreadPool.this._threads.size() > BoundedThreadPool.this._minThreads) && (now = System.currentTimeMillis()) - BoundedThreadPool.this._lastShrink > (long)BoundedThreadPool.this.getMaxIdleTimeMs()) {
                                    BoundedThreadPool.this._lastShrink = now;
                                    // MONITOREXIT @DISABLED, blocks:[0, 25, 29, 13] lbl25 : MonitorExitStatement: MONITOREXIT : todo
                                    Object var13_7 = null;
                                    break block30;
                                }
                                BoundedThreadPool.this._idle.add(this);
                            }
                            try {
                                try {
                                    todo = this;
                                    synchronized (todo) {
                                        if (this._job == null) {
                                            this.wait(BoundedThreadPool.this.getMaxIdleTimeMs());
                                        }
                                        job = this._job;
                                        this._job = null;
                                    }
                                }
                                catch (InterruptedException e) {
                                    Log.ignore(e);
                                    var9_5 = null;
                                    object = BoundedThreadPool.this._lock;
                                    synchronized (object) {
                                        BoundedThreadPool.this._idle.remove(this);
                                        continue;
                                    }
                                }
                                var9_5 = null;
                            }
                            catch (Throwable throwable) {
                                var9_5 = null;
                                object = BoundedThreadPool.this._lock;
                                synchronized (object) {
                                    BoundedThreadPool.this._idle.remove(this);
                                    throw throwable;
                                }
                            }
                            object = BoundedThreadPool.this._lock;
                            synchronized (object) {
                                BoundedThreadPool.this._idle.remove(this);
                            }
                        }
                        break block31;
                    }
                    catch (Throwable throwable) {
                        Object var13_9 = null;
                        Object object = BoundedThreadPool.this._lock;
                        synchronized (object) {
                            BoundedThreadPool.this._threads.remove(this);
                        }
                        Runnable job = null;
                        PoolThread poolThread = this;
                        synchronized (poolThread) {
                            job = this._job;
                        }
                        if (job == null) throw throwable;
                        if (!BoundedThreadPool.this.isRunning()) throw throwable;
                        BoundedThreadPool.this.dispatch(job);
                        throw throwable;
                    }
                }
                Object object = BoundedThreadPool.this._lock;
                synchronized (object) {
                    BoundedThreadPool.this._threads.remove(this);
                }
                Runnable job = null;
                PoolThread poolThread = this;
                synchronized (poolThread) {
                    job = this._job;
                }
                if (job == null) return;
                if (!BoundedThreadPool.this.isRunning()) return;
                BoundedThreadPool.this.dispatch(job);
                return;
            }
            Object var13_8 = null;
            Object object = BoundedThreadPool.this._lock;
            synchronized (object) {
                BoundedThreadPool.this._threads.remove(this);
            }
            Runnable job = null;
            PoolThread poolThread = this;
            synchronized (poolThread) {
                job = this._job;
            }
            if (job == null) return;
            if (!BoundedThreadPool.this.isRunning()) return;
            BoundedThreadPool.this.dispatch(job);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(Runnable job) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                if (this._job != null || job == null) {
                    throw new IllegalStateException();
                }
                this._job = job;
                this.notify();
            }
        }
    }
}

