/*
 * Decompiled with CFR 0.152.
 */
package io.warp10;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ThrowableUtils {
    public static final int MIN_MESSAGE_SIZE = 32;

    public static String getErrorMessage(Throwable t) {
        return ThrowableUtils.getErrorMessage(t, Integer.MAX_VALUE);
    }

    public static String getErrorMessage(Throwable t, int maxSize) {
        String simpleClassName = t.getClass().getSimpleName();
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        List<String> messages = new ArrayList<String>();
        while (null != t && !throwables.contains(t)) {
            String message = t.getMessage();
            if (null != message) {
                messages.add(message);
            }
            throwables.add(t);
            t = t.getCause();
        }
        String errorMessage = "";
        if (messages.isEmpty() || maxSize < 32) {
            errorMessage = StringUtils.abbreviate((String)simpleClassName, (int)maxSize);
        } else {
            StringBuilder errorMessageBuilder = ThrowableUtils.buildErrorMessage(messages);
            if (errorMessageBuilder.length() > maxSize) {
                String newMessage;
                String originalMessage;
                int maxMessages = maxSize / 32;
                if (messages.size() > maxMessages) {
                    messages = messages.subList(0, maxMessages - 1);
                    messages.add("...");
                }
                int target = maxSize / messages.size() - 3;
                int excess = errorMessageBuilder.length() - maxSize;
                for (int i = messages.size() - 1; i >= 0 && excess > 0; excess -= originalMessage.length() - newMessage.length(), --i) {
                    originalMessage = messages.get(i);
                    newMessage = StringUtils.abbreviateMiddle((String)originalMessage, (String)"...", (int)Math.max(target, originalMessage.length() - excess));
                    messages.set(i, newMessage);
                }
                errorMessageBuilder = ThrowableUtils.buildErrorMessage(messages);
            }
            errorMessage = errorMessageBuilder.toString();
        }
        return errorMessage;
    }

    public static StringBuilder buildErrorMessage(Collection<String> messages) {
        StringBuilder errorMessageBuilder = new StringBuilder();
        boolean nextMessage = false;
        for (String message : messages) {
            if (nextMessage) {
                errorMessageBuilder.append(" (");
            } else {
                nextMessage = true;
            }
            errorMessageBuilder.append(message);
        }
        for (int i = 0; i < messages.size() - 1; ++i) {
            errorMessageBuilder.append(")");
        }
        return errorMessageBuilder;
    }
}

