/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum;

import com.google.common.primitives.Longs;
import io.warp10.WarpConfig;
import io.warp10.WarpURLDecoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.store.thrift.data.Metadata;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetadataUtils {
    private static final int MAX_LABELS_SIZE;
    private static final int MAX_ATTRIBUTES_SIZE;
    public static final int SIZE_THRESHOLD;
    private static final Pattern METADATA_PATTERN;

    public static Metadata parseMetadata(String str) {
        Matcher m = METADATA_PATTERN.matcher(str.trim());
        if (!m.matches()) {
            return null;
        }
        try {
            String name = WarpURLDecoder.decode(m.group(1), StandardCharsets.UTF_8);
            Map<String, String> labels = GTSHelper.parseLabels(m.group(2));
            Map<String, String> attributes = GTSHelper.parseLabels(m.group(3));
            Metadata metadata = new Metadata();
            metadata.setName(name);
            metadata.setLabels(labels);
            metadata.setAttributes(attributes);
            return metadata;
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static boolean validateMetadata(Metadata metadata) {
        if (null == metadata) {
            return false;
        }
        if (null != metadata.getAttributes()) {
            if (metadata.getAttributes().containsKey(".producer")) {
                return false;
            }
            if (metadata.getAttributes().containsKey(".owner")) {
                return false;
            }
            if (metadata.getAttributes().containsKey(".app")) {
                return false;
            }
        }
        if (null != metadata.getLabels() && null != metadata.getAttributes()) {
            for (String key : metadata.getAttributes().keySet()) {
                if (!metadata.getLabels().containsKey(key)) continue;
                return false;
            }
        }
        int total = 0;
        if (null != metadata.getLabels()) {
            for (Map.Entry<String, String> entry : metadata.getLabels().entrySet()) {
                total += entry.getKey().length();
                total += entry.getValue().length();
            }
            if (total > MAX_LABELS_SIZE) {
                return false;
            }
        }
        total = 0;
        if (null != metadata.getAttributes()) {
            for (Map.Entry<String, String> entry : metadata.getAttributes().entrySet()) {
                total += entry.getKey().length();
                total += entry.getValue().length();
            }
            if (total > MAX_ATTRIBUTES_SIZE) {
                return false;
            }
        }
        return true;
    }

    public static MetadataID id(Metadata meta) {
        return new MetadataID(meta);
    }

    public static MetadataID id(MetadataID id, Metadata meta) {
        if (null == id) {
            return MetadataUtils.id(meta);
        }
        id.classId = meta.getClassId();
        id.labelsId = meta.getLabelsId();
        return id;
    }

    public static int compare(Metadata m1, Metadata m2) {
        long l2;
        long c2;
        long c1 = m1.getClassId() >>> 1;
        if (c1 < (c2 = m2.getClassId() >>> 1)) {
            return -1;
        }
        if (c1 > c2) {
            return 1;
        }
        if ((m1.getClassId() & 1L) < (m2.getClassId() & 1L)) {
            return -1;
        }
        if ((m1.getClassId() & 1L) > (m2.getClassId() & 1L)) {
            return 1;
        }
        long l1 = m1.getLabelsId() >>> 1;
        if (l1 < (l2 = m2.getLabelsId() >>> 1)) {
            return -1;
        }
        if (l1 > l2) {
            return 1;
        }
        if ((m1.getLabelsId() & 1L) < (m2.getLabelsId() & 1L)) {
            return -1;
        }
        if ((m1.getLabelsId() & 1L) > (m2.getLabelsId() & 1L)) {
            return 1;
        }
        return 0;
    }

    public static byte[] HBaseRowKeyPrefix(Metadata meta) {
        byte[] rowkey = new byte[Constants.HBASE_RAW_DATA_KEY_PREFIX.length + 8 + 8 + 8];
        System.arraycopy(Constants.HBASE_RAW_DATA_KEY_PREFIX, 0, rowkey, 0, Constants.HBASE_RAW_DATA_KEY_PREFIX.length);
        System.arraycopy(Longs.toByteArray((long)meta.getClassId()), 0, rowkey, Constants.HBASE_RAW_DATA_KEY_PREFIX.length, 8);
        System.arraycopy(Longs.toByteArray((long)meta.getLabelsId()), 0, rowkey, Constants.HBASE_RAW_DATA_KEY_PREFIX.length + 8, 8);
        return rowkey;
    }

    static {
        METADATA_PATTERN = Pattern.compile("^+([^\\{]+)\\{([^\\}]*)\\}\\{([^\\}]*)\\}$");
        int internalLabels = 72 + ".producer".length() + ".owner".length() + ".app".length();
        MAX_LABELS_SIZE = internalLabels + Integer.parseInt(WarpConfig.getProperty("warp.labels.maxsize", "2048"));
        MAX_ATTRIBUTES_SIZE = Integer.parseInt(WarpConfig.getProperty("warp.attributes.maxsize", "8192"));
        SIZE_THRESHOLD = Math.min(MAX_LABELS_SIZE - internalLabels, MAX_ATTRIBUTES_SIZE);
    }

    public static class MetadataID {
        private long classId;
        private long labelsId;

        public MetadataID(Metadata metadata) {
            this.classId = metadata.getClassId();
            this.labelsId = metadata.getLabelsId();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MetadataID) {
                MetadataID id = (MetadataID)obj;
                return this.classId == id.classId && this.labelsId == id.labelsId;
            }
            return false;
        }

        public int hashCode() {
            return (int)((this.classId ^ this.labelsId) & 0xFFFFFFFFL);
        }
    }
}

