/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;

public class FFT {
    public static List<Object> fft(GeoTimeSerie gts, boolean complex) throws WarpScriptException {
        ArrayList<Object> fft = new ArrayList<Object>();
        if (GeoTimeSerie.TYPE.LONG != gts.type && GeoTimeSerie.TYPE.DOUBLE != gts.type) {
            throw new WarpScriptException("FFT can only be applied to numeric Geo Time Series.");
        }
        if (!GTSHelper.isBucketized(gts)) {
            throw new WarpScriptException("FFT can only be applied to bucketized Geo Time Series.");
        }
        GTSHelper.sort(gts);
        double[] x = new double[gts.values * 2];
        long bucketboundary = gts.lastbucket % gts.bucketspan;
        long lasttick = Long.MAX_VALUE;
        for (int i = 0; i < gts.values; ++i) {
            if (gts.ticks[i] % gts.bucketspan != bucketboundary) {
                throw new WarpScriptException("Found a tick not on a bucket boundary.");
            }
            if (lasttick == gts.ticks[i]) {
                throw new WarpScriptException("Found duplicate tick.");
            }
            if (Long.MAX_VALUE != lasttick && gts.ticks[i] - lasttick != gts.bucketspan) {
                throw new WarpScriptException("Found a displaced tick, should have been 'bucketspan' away from previous.");
            }
            lasttick = gts.ticks[i];
            x[i * 2] = ((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue();
        }
        DoubleFFT_1D dfft = new DoubleFFT_1D(x.length / 2);
        dfft.complexForward(x);
        GeoTimeSerie amplitudeGTS = null;
        GeoTimeSerie phaseGTS = null;
        GeoTimeSerie reGTS = null;
        GeoTimeSerie imGTS = null;
        if (complex) {
            reGTS = new GeoTimeSerie(gts.values);
            reGTS.setName(gts.getName());
            reGTS.setLabels(gts.getLabels());
            imGTS = new GeoTimeSerie(gts.values);
            imGTS.setName(gts.getName());
            imGTS.setLabels(gts.getLabels());
            fft.add(reGTS);
            fft.add(imGTS);
        } else {
            amplitudeGTS = new GeoTimeSerie(gts.values);
            amplitudeGTS.setName(gts.getName());
            amplitudeGTS.setLabels(gts.getLabels());
            phaseGTS = new GeoTimeSerie(gts.values);
            phaseGTS.setName(gts.getName());
            phaseGTS.setLabels(gts.getLabels());
            fft.add(amplitudeGTS);
            fft.add(phaseGTS);
        }
        int n = gts.values;
        for (int k = 0; k < gts.values; ++k) {
            if (complex) {
                GTSHelper.setValue(reGTS, k, x[2 * k]);
                GTSHelper.setValue(imGTS, k, x[2 * k + 1]);
                continue;
            }
            double amp = Math.sqrt(x[2 * k] * x[2 * k] + x[2 * k + 1] * x[2 * k + 1]);
            double phase = Math.atan2(x[2 * k + 1], x[2 * k]);
            GTSHelper.setValue(amplitudeGTS, k, amp);
            GTSHelper.setValue(phaseGTS, k, phase);
        }
        fft.add((double)Constants.TIME_UNITS_PER_S / (double)((long)n * gts.bucketspan));
        return fft;
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        private final boolean complex;

        public Builder(String name, boolean complex) {
            super(name);
            this.complex = complex;
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object top = stack.pop();
            if (top instanceof GeoTimeSerie) {
                stack.push(FFT.fft((GeoTimeSerie)top, this.complex));
            } else if (top instanceof List) {
                ArrayList<List<Object>> series = new ArrayList<List<Object>>();
                for (Object o : (List)top) {
                    if (!(o instanceof GeoTimeSerie)) {
                        stack.push(top);
                        throw new WarpScriptException("FFT can only operate on Geo Time Series instances.");
                    }
                    series.add(FFT.fft((GeoTimeSerie)o, this.complex));
                }
                stack.push(series);
            } else {
                stack.push(top);
                throw new WarpScriptException("FFT can only operate on Geo Time Series instances.");
            }
            return stack;
        }
    }
}

