/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class GTSComparator
implements Comparator<GeoTimeSerie> {
    @Override
    public int compare(GeoTimeSerie gts1, GeoTimeSerie gts2) {
        Object value2;
        Object value1;
        int differingLabel;
        int nameCompare = gts1.getName().compareTo(gts2.getName());
        if (0 != nameCompare) {
            return nameCompare;
        }
        Map<String, String> labels1 = gts1.getLabels();
        Map<String, String> labels2 = gts2.getLabels();
        ArrayList<String> keys1 = new ArrayList<String>();
        keys1.addAll(labels1.keySet());
        Collections.sort(keys1);
        ArrayList<String> keys2 = new ArrayList<String>();
        keys2.addAll(labels2.keySet());
        Collections.sort(keys2);
        for (differingLabel = 0; differingLabel < keys1.size() && differingLabel < keys2.size() && 0 == ((String)keys1.get(differingLabel)).compareTo((String)keys2.get(differingLabel)); ++differingLabel) {
        }
        int labelsCompare = 0;
        for (int i = 0; i < differingLabel; ++i) {
            value1 = labels1.get(keys1.get(i));
            labelsCompare = ((String)value1).compareTo((String)(value2 = labels2.get(keys1.get(i))));
            if (0 == labelsCompare) continue;
            return labelsCompare;
        }
        if (differingLabel != keys1.size() || differingLabel != keys2.size()) {
            if (differingLabel == keys1.size()) {
                return -1;
            }
            if (differingLabel == keys2.size()) {
                return 1;
            }
            return ((String)keys1.get(differingLabel)).compareTo((String)keys2.get(differingLabel));
        }
        GTSHelper.sort(gts1);
        GTSHelper.sort(gts2);
        int idx = 0;
        while (idx < gts1.values && idx < gts2.values) {
            if (gts1.ticks[gts1.values - 1 - idx] < gts2.ticks[gts2.values - 1 - idx]) {
                return -1;
            }
            if (gts1.ticks[gts1.values - 1 - idx] > gts2.ticks[gts2.values - 1 - idx]) {
                return 1;
            }
            value1 = GTSHelper.valueAtIndex(gts1, gts1.values - 1 - idx);
            if (value1.equals(value2 = GTSHelper.valueAtIndex(gts2, gts1.values - 1 - idx))) continue;
            if (value1 instanceof String || value2 instanceof String) {
                int comp = value1.toString().compareTo(value2.toString());
                if (0 != comp) {
                    return comp;
                }
            } else if (value1 instanceof Number && value2 instanceof Number) {
                int bdCompare;
                BigDecimal bd2;
                if (value1 instanceof Long) {
                    if (value2 instanceof Long) {
                        if (((Number)value1).longValue() < ((Number)value2).longValue()) {
                            return -1;
                        }
                        if (((Number)value1).longValue() > ((Number)value2).longValue()) {
                            return 1;
                        }
                    } else {
                        BigDecimal bd1 = new BigDecimal(((Number)value1).longValue());
                        bdCompare = bd1.compareTo(bd2 = new BigDecimal(((Number)value2).doubleValue()));
                        if (0 != bdCompare) {
                            return bdCompare;
                        }
                    }
                } else if (value1 instanceof Double) {
                    if (value2 instanceof Double) {
                        if (((Number)value1).doubleValue() < ((Number)value2).doubleValue()) {
                            return -1;
                        }
                        if (((Number)value1).doubleValue() > ((Number)value2).doubleValue()) {
                            return 1;
                        }
                    } else {
                        BigDecimal bd1 = new BigDecimal(((Number)value1).doubleValue());
                        bdCompare = bd1.compareTo(bd2 = new BigDecimal(((Number)value2).longValue()));
                        if (0 != bdCompare) {
                            return bdCompare;
                        }
                    }
                }
            } else if (value1 instanceof Boolean) {
                if (Boolean.FALSE.equals(value1)) {
                    return -1;
                }
                if (Boolean.TRUE.equals(value2)) {
                    return 1;
                }
            } else if (value2 instanceof Boolean) {
                if (Boolean.FALSE.equals(value2)) {
                    return 1;
                }
                if (Boolean.TRUE.equals(value2)) {
                    return -1;
                }
            }
            ++idx;
        }
        return 0;
    }
}

