/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.WarpConfig;
import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackRegistry;
import io.warp10.script.functions.INCLUDE;
import io.warp10.sensision.Sensision;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.file.FileURLConnection;

public class WarpScriptMacroLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(WarpScriptMacroLibrary.class);
    private static final Map<String, WarpScriptStack.Macro> macros;
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private static final long DEFAULT_MACRO_TTL = 600000L;
    private static long ttl;
    private static long hardTtl;
    private static final int maxcachesize;

    public static void addJar(String path) throws WarpScriptException {
        WarpScriptMacroLibrary.addJar(path, null);
    }

    private static void addJar(String path, String resource) throws WarpScriptException {
        File f = new File(path);
        if (!f.exists() || !f.isFile()) {
            throw new WarpScriptException("File not found " + f.getAbsolutePath());
        }
        JarFile jar = null;
        try {
            String basename = f.getName();
            jar = new JarFile(f);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".mc2") || null != resource && !resource.equals(name)) continue;
                name = name.substring(0, name.length() - ".mc2".length());
                InputStream in = jar.getInputStream(entry);
                WarpScriptStack.Macro macro = WarpScriptMacroLibrary.loadMacro(jar, in, name);
                macro.setSecure(true);
                macros.put(name, macro);
            }
            if (maxcachesize == macros.size()) {
                LOG.warn("Some cached library macros were evicted.");
            }
            Sensision.set((String)"warpscript.library.macros", (Map)Sensision.EMPTY_LABELS, (Object)macros.size());
        }
        catch (IOException ioe) {
            throw new WarpScriptException("Encountered error while loading " + f.getAbsolutePath(), ioe);
        }
        finally {
            if (null != jar) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WarpScriptStack.Macro loadMacro(Object root, InputStream in, String name) throws WarpScriptException {
        WarpScriptStack.Macro macro2;
        MemoryWarpScriptStack stack = null;
        try {
            INCLUDE iNCLUDE;
            AtomicBoolean enabled;
            StringBuilder sb;
            block18: {
                block17: {
                    byte[] buf = new byte[8192];
                    sb = new StringBuilder();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while (true) {
                        int len;
                        if ((len = in.read(buf)) < 0) {
                            in.close();
                            byte[] data = out.toByteArray();
                            sb.setLength(0);
                            sb.append(" ");
                            sb.append(new String(data, StandardCharsets.UTF_8));
                            sb.append("\n");
                            stack = new MemoryWarpScriptStack(null, null, new Properties());
                            stack.setAttribute("stack.name", "[WarpScriptMacroLibrary " + name + "]");
                            stack.maxLimits();
                            stack.setAttribute("macro.name", name);
                            enabled = new AtomicBoolean(true);
                            if (root instanceof File) {
                                break;
                            }
                            break block17;
                        }
                        out.write(buf, 0, len);
                    }
                    iNCLUDE = new INCLUDE("INCLUDE", (File)root, enabled);
                    break block18;
                }
                iNCLUDE = new INCLUDE("INCLUDE", (JarFile)root, enabled);
            }
            final INCLUDE include = iNCLUDE;
            stack.define("INCLUDE", new WarpScriptStack.Macro(){

                @Override
                public boolean isSecure() {
                    return true;
                }

                @Override
                public List<Object> statements() {
                    return new ArrayList<Object>(){
                        {
                            this.add(include);
                        }
                    };
                }
            });
            stack.execMulti(sb.toString());
            enabled.set(false);
            if (1 != stack.depth()) {
                throw new WarpScriptException("Stack depth was not 1 after the code execution.");
            }
            if (!(stack.peek() instanceof WarpScriptStack.Macro)) {
                throw new WarpScriptException("No macro was found on top of the stack.");
            }
            WarpScriptStack.Macro macro = (WarpScriptStack.Macro)stack.pop();
            macro.setSecure(true);
            macro.setNameRecursive(name);
            long macroTtl = ttl;
            if (null != stack.getAttribute("macro.ttl")) {
                macroTtl = (Long)stack.getAttribute("macro.ttl");
            }
            if (macroTtl > hardTtl) {
                macroTtl = hardTtl;
            }
            try {
                macro.setExpiry(Math.addExact(System.currentTimeMillis(), ttl));
            }
            catch (ArithmeticException ae) {
                macro.setExpiry(0x7FFFFFFFFFFFFFFEL);
            }
            macro2 = macro;
        }
        catch (IOException ioe) {
            try {
                throw new WarpScriptException(ioe);
            }
            catch (Throwable throwable) {
                WarpScriptStackRegistry.unregister(stack);
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        WarpScriptStackRegistry.unregister(stack);
        try {
            in.close();
            return macro2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return macro2;
    }

    public static WarpScriptStack.Macro find(String name) throws WarpScriptException {
        if (name.contains("/../") || name.contains("/./") || name.startsWith("../") || name.startsWith("./") || name.startsWith("/")) {
            return null;
        }
        WarpScriptStack.Macro macro = macros.get(name);
        if (null == macro || macro.isExpired()) {
            String rsc = name + ".mc2";
            URL url = WarpScriptMacroLibrary.class.getClassLoader().getResource(rsc);
            if (null != url) {
                try {
                    URLConnection conn = url.openConnection();
                    if (conn instanceof JarURLConnection) {
                        JarURLConnection connection = (JarURLConnection)url.openConnection();
                        URL fileurl = connection.getJarFileURL();
                        File f = new File(fileurl.toURI());
                        WarpScriptMacroLibrary.addJar(f.getAbsolutePath(), rsc);
                        macro = macros.get(name);
                    } else if (conn instanceof FileURLConnection) {
                        String urlstr = url.toString();
                        File root = new File(urlstr.substring(0, urlstr.length() - name.length() - ".mc2".length()));
                        macro = WarpScriptMacroLibrary.loadMacro(root, conn.getInputStream(), name);
                    }
                }
                catch (URISyntaxException use) {
                    throw new WarpScriptException("Error while loading '" + name + "'", use);
                }
                catch (IOException ioe) {
                    throw new WarpScriptException("Error while loading '" + name + "'", ioe);
                }
            }
        }
        return macro;
    }

    static {
        ttl = 600000L;
        hardTtl = 0x1FFFFFFFFFFFFFFFL;
        maxcachesize = Integer.parseInt(WarpConfig.getProperty("warpscript.library.cache.size", Integer.toString(10000)));
        macros = new LinkedHashMap<String, WarpScriptStack.Macro>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, WarpScriptStack.Macro> eldest) {
                int size = this.size();
                Sensision.set((String)"warpscript.library.macros", (Map)Sensision.EMPTY_LABELS, (Object)size);
                return size > maxcachesize;
            }
        };
        ttl = Long.parseLong(WarpConfig.getProperty("warpscript.library.ttl", Long.toString(600000L)));
        hardTtl = Long.parseLong(WarpConfig.getProperty("warpscript.library.ttl.hard", Long.toString(0x1FFFFFFFFFFFFFFFL)));
    }
}

